/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.issue;

import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.issue.ActionPlan;
import org.sonar.core.util.Uuids;

public class DefaultActionPlan
implements ActionPlan {
    private String key;
    private String name;
    private String projectKey;
    private String description;
    private String userLogin;
    private String status;
    private Date deadLine;
    private Date createdAt;
    private Date updatedAt;

    public static DefaultActionPlan create(String name) {
        DefaultActionPlan actionPlan = new DefaultActionPlan();
        actionPlan.setKey(Uuids.create());
        Date now = new Date();
        actionPlan.setName(name);
        actionPlan.setStatus("OPEN");
        actionPlan.setCreatedAt(now).setUpdatedAt(now);
        return actionPlan;
    }

    @Override
    public String key() {
        return this.key;
    }

    public DefaultActionPlan setKey(String key) {
        this.key = key;
        return this;
    }

    @Override
    public String name() {
        return this.name;
    }

    public DefaultActionPlan setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String projectKey() {
        return this.projectKey;
    }

    public DefaultActionPlan setProjectKey(String projectKey) {
        this.projectKey = projectKey;
        return this;
    }

    @Override
    @CheckForNull
    public String description() {
        return this.description;
    }

    public DefaultActionPlan setDescription(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Override
    public String userLogin() {
        return this.userLogin;
    }

    public DefaultActionPlan setUserLogin(String userLogin) {
        this.userLogin = userLogin;
        return this;
    }

    @Override
    public String status() {
        return this.status;
    }

    public DefaultActionPlan setStatus(String status) {
        this.status = status;
        return this;
    }

    @Override
    @CheckForNull
    public Date deadLine() {
        return this.deadLine != null ? new Date(this.deadLine.getTime()) : null;
    }

    public DefaultActionPlan setDeadLine(@Nullable Date deadLine) {
        this.deadLine = deadLine != null ? new Date(deadLine.getTime()) : null;
        return this;
    }

    @Override
    public Date createdAt() {
        return this.createdAt;
    }

    public DefaultActionPlan setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Override
    public Date updatedAt() {
        return this.updatedAt;
    }

    public DefaultActionPlan setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }
}

