/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.metric;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.batch.BatchSide;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.Metrics;
import org.sonar.api.server.ServerSide;

@ServerSide
@BatchSide
public class BatchMetrics {
    private static final Set<Metric> ALLOWED_CORE_METRICS = ImmutableSet.of(CoreMetrics.LINES, CoreMetrics.GENERATED_LINES, CoreMetrics.NCLOC, CoreMetrics.NCLOC_DATA, CoreMetrics.GENERATED_NCLOC, CoreMetrics.COMMENT_LINES, (Object[])new Metric[]{CoreMetrics.COMMENT_LINES_DATA, CoreMetrics.NCLOC_LANGUAGE_DISTRIBUTION, CoreMetrics.COMMENTED_OUT_CODE_LINES, CoreMetrics.PUBLIC_API, CoreMetrics.PUBLIC_UNDOCUMENTED_API, CoreMetrics.FILES, CoreMetrics.DIRECTORIES, CoreMetrics.CLASSES, CoreMetrics.FUNCTIONS, CoreMetrics.STATEMENTS, CoreMetrics.ACCESSORS, CoreMetrics.DUPLICATED_LINES, CoreMetrics.DUPLICATED_BLOCKS, CoreMetrics.DUPLICATED_FILES, CoreMetrics.COMPLEXITY, CoreMetrics.COMPLEXITY_IN_CLASSES, CoreMetrics.COMPLEXITY_IN_FUNCTIONS, CoreMetrics.FILE_COMPLEXITY_DISTRIBUTION, CoreMetrics.FUNCTION_COMPLEXITY_DISTRIBUTION, CoreMetrics.TESTS, CoreMetrics.SKIPPED_TESTS, CoreMetrics.TEST_ERRORS, CoreMetrics.TEST_FAILURES, CoreMetrics.TEST_EXECUTION_TIME, CoreMetrics.LINES_TO_COVER, CoreMetrics.UNCOVERED_LINES, CoreMetrics.COVERAGE_LINE_HITS_DATA, CoreMetrics.CONDITIONS_TO_COVER, CoreMetrics.UNCOVERED_CONDITIONS, CoreMetrics.COVERED_CONDITIONS_BY_LINE, CoreMetrics.CONDITIONS_BY_LINE, CoreMetrics.IT_LINES_TO_COVER, CoreMetrics.IT_UNCOVERED_LINES, CoreMetrics.IT_COVERAGE_LINE_HITS_DATA, CoreMetrics.IT_CONDITIONS_TO_COVER, CoreMetrics.IT_UNCOVERED_CONDITIONS, CoreMetrics.IT_COVERED_CONDITIONS_BY_LINE, CoreMetrics.IT_CONDITIONS_BY_LINE, CoreMetrics.OVERALL_LINES_TO_COVER, CoreMetrics.OVERALL_UNCOVERED_LINES, CoreMetrics.OVERALL_COVERAGE_LINE_HITS_DATA, CoreMetrics.OVERALL_CONDITIONS_TO_COVER, CoreMetrics.OVERALL_UNCOVERED_CONDITIONS, CoreMetrics.OVERALL_COVERED_CONDITIONS_BY_LINE, CoreMetrics.OVERALL_CONDITIONS_BY_LINE, CoreMetrics.QUALITY_PROFILES});
    private final Set<Metric> metrics;

    public BatchMetrics(Metrics[] metricsRepositories) {
        this.metrics = ImmutableSet.copyOf((Iterable)Iterables.concat(BatchMetrics.getPluginMetrics(metricsRepositories), ALLOWED_CORE_METRICS));
    }

    public Set<Metric> getMetrics() {
        return this.metrics;
    }

    private static Iterable<Metric> getPluginMetrics(Metrics[] metricsRepositories) {
        return FluentIterable.from(Arrays.asList(metricsRepositories)).transformAndConcat((Function)FlattenMetrics.INSTANCE);
    }

    private static enum FlattenMetrics implements Function<Metrics, List<Metric>>
    {
        INSTANCE;


        @Nullable
        public List<Metric> apply(Metrics input) {
            return input.getMetrics();
        }
    }
}

