/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.issue.workflow;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.issue.Issue;
import org.sonar.api.issue.condition.Condition;
import org.sonar.core.issue.workflow.Function;

public class Transition {
    private final String key;
    private final String from;
    private final String to;
    private final Condition[] conditions;
    private final Function[] functions;
    private final boolean automatic;
    private String requiredProjectPermission;

    private Transition(TransitionBuilder builder) {
        this.key = builder.key;
        this.from = builder.from;
        this.to = builder.to;
        this.conditions = builder.conditions.toArray(new Condition[builder.conditions.size()]);
        this.functions = builder.functions.toArray(new Function[builder.functions.size()]);
        this.automatic = builder.automatic;
        this.requiredProjectPermission = builder.requiredProjectPermission;
    }

    public String key() {
        return this.key;
    }

    String from() {
        return this.from;
    }

    String to() {
        return this.to;
    }

    Condition[] conditions() {
        return this.conditions;
    }

    Function[] functions() {
        return this.functions;
    }

    boolean automatic() {
        return this.automatic;
    }

    public boolean supports(Issue issue) {
        for (Condition condition : this.conditions) {
            if (condition.matches(issue)) continue;
            return false;
        }
        return true;
    }

    public String requiredProjectPermission() {
        return this.requiredProjectPermission;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transition that = (Transition)o;
        if (!this.from.equals(that.from)) {
            return false;
        }
        if (!this.key.equals(that.key)) {
            return false;
        }
        return this.to.equals(that.to);
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + this.from.hashCode();
        result = 31 * result + this.to.hashCode();
        return result;
    }

    public String toString() {
        return String.format("%s->%s->%s", this.from, this.key, this.to);
    }

    public static Transition create(String key, String from, String to) {
        return Transition.builder(key).from(from).to(to).build();
    }

    public static TransitionBuilder builder(String key) {
        return new TransitionBuilder(key);
    }

    public static class TransitionBuilder {
        private final String key;
        private String from;
        private String to;
        private List<Condition> conditions = Lists.newArrayList();
        private List<Function> functions = Lists.newArrayList();
        private boolean automatic = false;
        private String requiredProjectPermission;

        private TransitionBuilder(String key) {
            this.key = key;
        }

        public TransitionBuilder from(String from) {
            this.from = from;
            return this;
        }

        public TransitionBuilder to(String to) {
            this.to = to;
            return this;
        }

        public TransitionBuilder conditions(Condition ... c) {
            this.conditions.addAll(Arrays.asList(c));
            return this;
        }

        public TransitionBuilder functions(Function ... f) {
            this.functions.addAll(Arrays.asList(f));
            return this;
        }

        public TransitionBuilder automatic() {
            this.automatic = true;
            return this;
        }

        public TransitionBuilder requiredProjectPermission(String requiredProjectPermission) {
            this.requiredProjectPermission = requiredProjectPermission;
            return this;
        }

        public Transition build() {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.key) ? 1 : 0) != 0, (Object)"Transition key must be set");
            Preconditions.checkArgument((boolean)StringUtils.isAllLowerCase(this.key), (Object)"Transition key must be lower-case");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.from) ? 1 : 0) != 0, (Object)"Originating status must be set");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.to) ? 1 : 0) != 0, (Object)"Destination status must be set");
            return new Transition(this);
        }
    }
}

