/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.protocol.input;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.batch.protocol.GsonHelper;
import org.sonar.batch.protocol.input.FileData;

public class ProjectRepositories {
    private long timestamp;
    private boolean exists;
    private Map<String, Map<String, String>> settingsByModule = new HashMap<String, Map<String, String>>();
    private Map<String, Map<String, FileData>> fileDataByModuleAndPath = new HashMap<String, Map<String, FileData>>();
    private Date lastAnalysisDate;

    public Map<String, String> settings(String moduleKey) {
        return this.settingsByModule.containsKey(moduleKey) ? this.settingsByModule.get(moduleKey) : Collections.emptyMap();
    }

    public Map<String, Map<String, String>> settings() {
        return this.settingsByModule;
    }

    public ProjectRepositories addSettings(String moduleKey, Map<String, String> settings) {
        Map<String, String> existingSettings = this.settingsByModule.get(moduleKey);
        if (existingSettings == null) {
            existingSettings = new HashMap<String, String>();
            this.settingsByModule.put(moduleKey, existingSettings);
        }
        existingSettings.putAll(settings);
        return this;
    }

    public boolean exists() {
        return this.exists;
    }

    public Map<String, Map<String, FileData>> fileDataByModuleAndPath() {
        return this.fileDataByModuleAndPath;
    }

    public Map<String, FileData> fileDataByPath(String moduleKey) {
        return this.fileDataByModuleAndPath.containsKey(moduleKey) ? this.fileDataByModuleAndPath.get(moduleKey) : Collections.emptyMap();
    }

    public ProjectRepositories addFileData(String moduleKey, @Nullable String path, FileData fileData) {
        if (path == null || fileData.hash() == null && fileData.revision() == null) {
            return this;
        }
        Map<String, FileData> existingFileDataByPath = this.fileDataByModuleAndPath.get(moduleKey);
        if (existingFileDataByPath == null) {
            existingFileDataByPath = new HashMap<String, FileData>();
            this.fileDataByModuleAndPath.put(moduleKey, existingFileDataByPath);
        }
        existingFileDataByPath.put(path, fileData);
        return this;
    }

    @CheckForNull
    public FileData fileData(String projectKey, String path) {
        return this.fileDataByPath(projectKey).get(path);
    }

    public long timestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @CheckForNull
    public Date lastAnalysisDate() {
        return this.lastAnalysisDate;
    }

    public void setLastAnalysisDate(@Nullable Date lastAnalysisDate) {
        this.lastAnalysisDate = lastAnalysisDate;
    }

    public String toJson() {
        return GsonHelper.create().toJson(this);
    }

    public static ProjectRepositories fromJson(String json) {
        return GsonHelper.create().fromJson(json, ProjectRepositories.class);
    }
}

