/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public final class ParsingUtils {
    private ParsingUtils() {
    }

    public static double parseNumber(String number, Locale locale) throws ParseException {
        if ("".equals(number)) {
            return Double.NaN;
        }
        return NumberFormat.getNumberInstance(locale).parse(number).doubleValue();
    }

    public static double parseNumber(String number) throws ParseException {
        return ParsingUtils.parseNumber(number, Locale.getDefault());
    }

    public static double scaleValue(double value) {
        return ParsingUtils.scaleValue(value, 2);
    }

    public static double scaleValue(double value, int decimals) {
        BigDecimal bd = BigDecimal.valueOf(value);
        return bd.setScale(decimals, RoundingMode.HALF_UP).doubleValue();
    }
}

