/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.rule;

import java.lang.reflect.Field;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.internal.google.common.annotations.VisibleForTesting;
import org.sonar.api.internal.google.common.base.Function;
import org.sonar.api.internal.google.common.base.Functions;
import org.sonar.api.internal.google.common.collect.ImmutableMap;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.server.rule.RuleParamType;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.api.utils.FieldUtils2;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.check.Cardinality;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

public class RulesDefinitionAnnotationLoader {
    private static final Logger LOG = Loggers.get(RulesDefinitionAnnotationLoader.class);
    private static final Function<Class<?>, RuleParamType> TYPE_FOR_CLASS = Functions.forMap(ImmutableMap.builder().put(Integer.class, RuleParamType.INTEGER).put(Integer.TYPE, RuleParamType.INTEGER).put(Float.class, RuleParamType.FLOAT).put(Float.TYPE, RuleParamType.FLOAT).put(Boolean.class, RuleParamType.BOOLEAN).put(Boolean.TYPE, RuleParamType.BOOLEAN).build(), RuleParamType.STRING);

    public void load(RulesDefinition.NewExtendedRepository repo, Class ... annotatedClasses) {
        for (Class annotatedClass : annotatedClasses) {
            this.loadRule(repo, annotatedClass);
        }
    }

    @CheckForNull
    RulesDefinition.NewRule loadRule(RulesDefinition.NewExtendedRepository repo, Class clazz) {
        Rule ruleAnnotation = AnnotationUtils.getAnnotation(clazz, Rule.class);
        if (ruleAnnotation != null) {
            return this.loadRule(repo, clazz, ruleAnnotation);
        }
        LOG.warn("The class " + clazz.getCanonicalName() + " should be annotated with " + Rule.class);
        return null;
    }

    private RulesDefinition.NewRule loadRule(RulesDefinition.NewExtendedRepository repo, Class clazz, Rule ruleAnnotation) {
        String ruleKey = StringUtils.defaultIfEmpty(ruleAnnotation.key(), clazz.getCanonicalName());
        String ruleName = StringUtils.defaultIfEmpty(ruleAnnotation.name(), null);
        String description = StringUtils.defaultIfEmpty(ruleAnnotation.description(), null);
        RulesDefinition.NewRule rule = repo.createRule(ruleKey);
        rule.setName(ruleName).setHtmlDescription(description);
        rule.setSeverity(ruleAnnotation.priority().name());
        rule.setTemplate(ruleAnnotation.cardinality() == Cardinality.MULTIPLE);
        rule.setStatus(RuleStatus.valueOf(ruleAnnotation.status()));
        rule.setTags(ruleAnnotation.tags());
        List<Field> fields = FieldUtils2.getFields(clazz, true);
        for (Field field : fields) {
            this.loadParameters(rule, field);
        }
        return rule;
    }

    private void loadParameters(RulesDefinition.NewRule rule, Field field) {
        RuleProperty propertyAnnotation = field.getAnnotation(RuleProperty.class);
        if (propertyAnnotation != null) {
            String fieldKey = StringUtils.defaultIfEmpty(propertyAnnotation.key(), field.getName());
            RulesDefinition.NewParam param = rule.createParam(fieldKey).setDescription(propertyAnnotation.description()).setDefaultValue(propertyAnnotation.defaultValue());
            if (!StringUtils.isBlank(propertyAnnotation.type())) {
                try {
                    param.setType(RuleParamType.parse(propertyAnnotation.type().trim()));
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Invalid property type [" + propertyAnnotation.type() + "]", e);
                }
            } else {
                param.setType(RulesDefinitionAnnotationLoader.guessType(field.getType()));
            }
        }
    }

    @VisibleForTesting
    static RuleParamType guessType(Class<?> type) {
        return TYPE_FOR_CLASS.apply(type);
    }
}

