/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.protocol.output;

import java.io.File;
import javax.annotation.CheckForNull;
import org.sonar.batch.protocol.output.BatchReport;
import org.sonar.batch.protocol.output.FileStructure;
import org.sonar.core.util.CloseableIterator;
import org.sonar.core.util.Protobuf;

public class BatchReportReader {
    private final FileStructure fileStructure;

    public BatchReportReader(File dir) {
        this.fileStructure = new FileStructure(dir);
    }

    public BatchReport.Metadata readMetadata() {
        File file = this.fileStructure.metadataFile();
        if (!BatchReportReader.fileExists(file)) {
            throw new IllegalStateException("Metadata file is missing in analysis report: " + file);
        }
        return (BatchReport.Metadata)Protobuf.read((File)file, BatchReport.Metadata.PARSER);
    }

    public CloseableIterator<BatchReport.ActiveRule> readActiveRules() {
        File file = this.fileStructure.activeRules();
        if (!BatchReportReader.fileExists(file)) {
            return CloseableIterator.emptyCloseableIterator();
        }
        return Protobuf.readStream((File)file, BatchReport.ActiveRule.PARSER);
    }

    public CloseableIterator<BatchReport.Measure> readComponentMeasures(int componentRef) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.MEASURES, componentRef);
        if (BatchReportReader.fileExists(file)) {
            return Protobuf.readStream((File)file, BatchReport.Measure.PARSER);
        }
        return CloseableIterator.emptyCloseableIterator();
    }

    @CheckForNull
    public BatchReport.Changesets readChangesets(int componentRef) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.CHANGESETS, componentRef);
        if (BatchReportReader.fileExists(file)) {
            return (BatchReport.Changesets)Protobuf.read((File)file, BatchReport.Changesets.PARSER);
        }
        return null;
    }

    public BatchReport.Component readComponent(int componentRef) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.COMPONENT, componentRef);
        if (!BatchReportReader.fileExists(file)) {
            throw new IllegalStateException("Unable to find report for component #" + componentRef + ". File does not exist: " + file);
        }
        return (BatchReport.Component)Protobuf.read((File)file, BatchReport.Component.PARSER);
    }

    public CloseableIterator<BatchReport.Issue> readComponentIssues(int componentRef) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.ISSUES, componentRef);
        if (BatchReportReader.fileExists(file)) {
            return Protobuf.readStream((File)file, BatchReport.Issue.PARSER);
        }
        return CloseableIterator.emptyCloseableIterator();
    }

    public CloseableIterator<BatchReport.Duplication> readComponentDuplications(int componentRef) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.DUPLICATIONS, componentRef);
        if (BatchReportReader.fileExists(file)) {
            return Protobuf.readStream((File)file, BatchReport.Duplication.PARSER);
        }
        return CloseableIterator.emptyCloseableIterator();
    }

    public CloseableIterator<BatchReport.CpdTextBlock> readCpdTextBlocks(int componentRef) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.CPD_TEXT_BLOCKS, componentRef);
        if (BatchReportReader.fileExists(file)) {
            return Protobuf.readStream((File)file, BatchReport.CpdTextBlock.parser());
        }
        return CloseableIterator.emptyCloseableIterator();
    }

    public CloseableIterator<BatchReport.Symbol> readComponentSymbols(int componentRef) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.SYMBOLS, componentRef);
        if (BatchReportReader.fileExists(file)) {
            return Protobuf.readStream((File)file, BatchReport.Symbol.PARSER);
        }
        return CloseableIterator.emptyCloseableIterator();
    }

    public boolean hasSyntaxHighlighting(int componentRef) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.SYNTAX_HIGHLIGHTINGS, componentRef);
        return file.exists();
    }

    public CloseableIterator<BatchReport.SyntaxHighlighting> readComponentSyntaxHighlighting(int fileRef) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.SYNTAX_HIGHLIGHTINGS, fileRef);
        if (BatchReportReader.fileExists(file)) {
            return Protobuf.readStream((File)file, BatchReport.SyntaxHighlighting.PARSER);
        }
        return CloseableIterator.emptyCloseableIterator();
    }

    public boolean hasCoverage(int componentRef) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.COVERAGES, componentRef);
        return file.exists();
    }

    public CloseableIterator<BatchReport.Coverage> readComponentCoverage(int fileRef) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.COVERAGES, fileRef);
        if (BatchReportReader.fileExists(file)) {
            return Protobuf.readStream((File)file, BatchReport.Coverage.PARSER);
        }
        return CloseableIterator.emptyCloseableIterator();
    }

    @CheckForNull
    public File readFileSource(int fileRef) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.SOURCE, fileRef);
        if (BatchReportReader.fileExists(file)) {
            return file;
        }
        return null;
    }

    @CheckForNull
    public File readTests(int testFileRef) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.TESTS, testFileRef);
        if (BatchReportReader.fileExists(file)) {
            return file;
        }
        return null;
    }

    @CheckForNull
    public File readCoverageDetails(int testFileRef) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.COVERAGE_DETAILS, testFileRef);
        if (BatchReportReader.fileExists(file)) {
            return file;
        }
        return null;
    }

    private static boolean fileExists(File file) {
        return file.exists() && file.isFile();
    }

    public FileStructure getFileStructure() {
        return this.fileStructure;
    }
}

