/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.protocol.output;

import com.google.protobuf.Message;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import org.sonar.batch.protocol.output.BatchReport;
import org.sonar.batch.protocol.output.FileStructure;
import org.sonar.core.util.ContextException;
import org.sonar.core.util.Protobuf;

public class BatchReportWriter {
    private final FileStructure fileStructure;

    public BatchReportWriter(File dir) {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalStateException("Unable to create directory: " + dir);
        }
        this.fileStructure = new FileStructure(dir);
    }

    public FileStructure getFileStructure() {
        return this.fileStructure;
    }

    public boolean hasComponentData(FileStructure.Domain domain, int componentRef) {
        File file = this.fileStructure.fileFor(domain, componentRef);
        return file.exists() && file.isFile();
    }

    public File writeMetadata(BatchReport.Metadata metadata) {
        Protobuf.write((Message)metadata, (File)this.fileStructure.metadataFile());
        return this.fileStructure.metadataFile();
    }

    public File writeActiveRules(Iterable<BatchReport.ActiveRule> activeRules) {
        Protobuf.writeStream(activeRules, (File)this.fileStructure.activeRules(), (boolean)false);
        return this.fileStructure.metadataFile();
    }

    public File writeComponent(BatchReport.Component component) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.COMPONENT, component.getRef());
        Protobuf.write((Message)component, (File)file);
        return file;
    }

    public File writeComponentIssues(int componentRef, Iterable<BatchReport.Issue> issues) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.ISSUES, componentRef);
        Protobuf.writeStream(issues, (File)file, (boolean)false);
        return file;
    }

    public void appendComponentIssue(int componentRef, BatchReport.Issue issue) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.ISSUES, componentRef);
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file, true));){
            issue.writeDelimitedTo(out);
        }
        catch (Exception e) {
            throw ContextException.of((String)"Unable to write issue", (Throwable)e).addContext("file", (Object)file);
        }
    }

    public File writeComponentMeasures(int componentRef, Iterable<BatchReport.Measure> measures) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.MEASURES, componentRef);
        Protobuf.writeStream(measures, (File)file, (boolean)false);
        return file;
    }

    public File writeComponentChangesets(BatchReport.Changesets changesets) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.CHANGESETS, changesets.getComponentRef());
        Protobuf.write((Message)changesets, (File)file);
        return file;
    }

    public File writeComponentDuplications(int componentRef, Iterable<BatchReport.Duplication> duplications) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.DUPLICATIONS, componentRef);
        Protobuf.writeStream(duplications, (File)file, (boolean)false);
        return file;
    }

    public File writeCpdTextBlocks(int componentRef, Iterable<BatchReport.CpdTextBlock> blocks) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.CPD_TEXT_BLOCKS, componentRef);
        Protobuf.writeStream(blocks, (File)file, (boolean)false);
        return file;
    }

    public File writeComponentSymbols(int componentRef, Iterable<BatchReport.Symbol> symbols) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.SYMBOLS, componentRef);
        Protobuf.writeStream(symbols, (File)file, (boolean)false);
        return file;
    }

    public File writeComponentSyntaxHighlighting(int componentRef, Iterable<BatchReport.SyntaxHighlighting> syntaxHighlightingRules) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.SYNTAX_HIGHLIGHTINGS, componentRef);
        Protobuf.writeStream(syntaxHighlightingRules, (File)file, (boolean)false);
        return file;
    }

    public File writeComponentCoverage(int componentRef, Iterable<BatchReport.Coverage> coverageList) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.COVERAGES, componentRef);
        Protobuf.writeStream(coverageList, (File)file, (boolean)false);
        return file;
    }

    public File writeTests(int componentRef, Iterable<BatchReport.Test> tests) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.TESTS, componentRef);
        Protobuf.writeStream(tests, (File)file, (boolean)false);
        return file;
    }

    public File writeCoverageDetails(int componentRef, Iterable<BatchReport.CoverageDetail> tests) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.COVERAGE_DETAILS, componentRef);
        Protobuf.writeStream(tests, (File)file, (boolean)false);
        return file;
    }

    public File getSourceFile(int componentRef) {
        return this.fileStructure.fileFor(FileStructure.Domain.SOURCE, componentRef);
    }
}

