/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class UtcDateUtils {
    private static final ThreadLocal<DateFormat> format = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
            f.setTimeZone(TimeZone.getTimeZone("UTC"));
            return f;
        }
    };

    private UtcDateUtils() {
    }

    public static String formatDateTime(Date date) {
        return format.get().format(date);
    }

    public static Date parseDateTime(String s) {
        try {
            return format.get().parse(s);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Fail to parse date: " + s, e);
        }
    }
}

