/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner.impl;

import java.io.File;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Properties;
import org.sonar.runner.batch.IsolatedLauncher;
import org.sonar.runner.cache.Logger;
import org.sonar.runner.cache.PersistentCache;
import org.sonar.runner.cache.PersistentCacheBuilder;
import org.sonar.runner.impl.ClassloadRules;
import org.sonar.runner.impl.IsolatedClassloader;
import org.sonar.runner.impl.IsolatedLauncherProxy;
import org.sonar.runner.impl.JarDownloader;
import org.sonar.runner.impl.RunnerException;
import org.sonar.runner.impl.ServerConnection;
import org.sonar.runner.impl.SimulatedLauncher;
import org.sonar.runner.impl.TempCleaning;

public class IsolatedLauncherFactory {
    static final String ISOLATED_LAUNCHER_IMPL = "org.sonar.runner.batch.BatchIsolatedLauncher";
    private final TempCleaning tempCleaning;
    private final String launcherImplClassName;
    private final Logger logger;

    IsolatedLauncherFactory(String isolatedLauncherClassName, TempCleaning tempCleaning, Logger logger) {
        this.tempCleaning = tempCleaning;
        this.launcherImplClassName = isolatedLauncherClassName;
        this.logger = logger;
    }

    public IsolatedLauncherFactory(Logger logger) {
        this(ISOLATED_LAUNCHER_IMPL, new TempCleaning(logger), logger);
    }

    private PersistentCache getCache(Properties props) {
        PersistentCacheBuilder builder = new PersistentCacheBuilder(this.logger);
        String serverUrl = props.getProperty("sonar.host.url");
        String home = props.getProperty("sonar.userHome");
        builder.setAreaForGlobal(serverUrl);
        if (home != null) {
            builder.setSonarHome(Paths.get(home, new String[0]));
        }
        return builder.build();
    }

    private ClassLoader createClassLoader(List<File> jarFiles, ClassloadRules maskRules) {
        IsolatedClassloader classloader = new IsolatedClassloader(this.getClass().getClassLoader(), maskRules);
        classloader.addFiles(jarFiles);
        return classloader;
    }

    public IsolatedLauncher createLauncher(Properties props, ClassloadRules rules, boolean preferCache) {
        if (props.containsKey("sonarRunner.dumpToFile")) {
            String version = props.getProperty("sonarRunner.versionSimulation");
            if (version == null) {
                version = "5.2";
            }
            return new SimulatedLauncher(version, this.logger);
        }
        ServerConnection serverConnection = ServerConnection.create(props, this.getCache(props), this.logger, preferCache);
        JarDownloader jarDownloader = new JarDownloader(serverConnection, this.logger, props);
        return this.createLauncher(jarDownloader, rules);
    }

    IsolatedLauncher createLauncher(final JarDownloader jarDownloader, final ClassloadRules rules) {
        return AccessController.doPrivileged(new PrivilegedAction<IsolatedLauncher>(){

            @Override
            public IsolatedLauncher run() {
                try {
                    List<File> jarFiles = jarDownloader.download();
                    IsolatedLauncherFactory.this.logger.debug("Create isolated classloader...");
                    ClassLoader cl = IsolatedLauncherFactory.this.createClassLoader(jarFiles, rules);
                    IsolatedLauncher objProxy = IsolatedLauncherProxy.create(cl, IsolatedLauncher.class, IsolatedLauncherFactory.this.launcherImplClassName, IsolatedLauncherFactory.this.logger);
                    IsolatedLauncherFactory.this.tempCleaning.clean();
                    return objProxy;
                }
                catch (Exception e) {
                    throw new RunnerException("Unable to execute SonarQube", e);
                }
            }
        });
    }
}

