/*
 * Decompiled with CFR 0.152.
 */
package com.persistit.ui;

import com.persistit.Key;
import com.persistit.KeyState;
import com.persistit.Management;
import com.persistit.ui.AdminUI;
import com.persistit.ui.ManagementTableModel;
import java.rmi.RemoteException;
import javax.swing.SwingUtilities;

class ManagementSlidingTableModel
extends ManagementTableModel {
    public static final int DEFAULT_ROW_CACHE_SIZE = 2048;
    public static final int DEFAULT_INITIAL_SIZE_ESTIMATE = 10000;
    public static final int SCROLL_BAR_ESTIMATE_MULTIPLIER = 3;
    public static final int MAXIMUM_GROWTH_ESTIMATE = 100000;
    public static final int DEFAULT_MAXIMUM_VALUE_SIZE = 400;
    public static final int MINIMUM_REQUESTED_ROW_COUNT = 256;
    private int _offset;
    private boolean _deletingRows;
    private final int _rowCacheSize = 2048;
    private final int _maxValueSize = 400;
    private int _currentRowCount;
    private boolean _definite;
    private int _valid = 0;
    private String _volumeName;
    private String _treeName;
    private String _keyFilterString;
    private boolean _waiting;

    public ManagementSlidingTableModel(Class clazz, String className, AdminUI ui) throws NoSuchMethodException {
        super(clazz, className, ui);
    }

    void reset() {
        this._volumeName = null;
        this._treeName = null;
        this._keyFilterString = null;
        this._valid = 0;
        this._offset = 0;
        this._currentRowCount = 10000;
        this._definite = false;
    }

    void set(String volumeName, String treeName, String keyFilterString) {
        this.reset();
        this._volumeName = volumeName;
        this._treeName = treeName;
        this._keyFilterString = keyFilterString;
        this.fireTableDataChanged();
    }

    boolean isDeletingRows() {
        return this._deletingRows;
    }

    @Override
    public int getRowCount() {
        return this._currentRowCount;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row < 0 || this._definite && row >= this._currentRowCount) {
            return null;
        }
        if (col >= 0 && (row < this._offset || row >= this._offset + this._valid)) {
            return this.fetch(row);
        }
        return super.getValueAt(row - this._offset, col);
    }

    private synchronized Object fetch(int row) {
        int requestedCount;
        int fromOffset;
        boolean forward;
        if (this._waiting) {
            return this._adminUI.getWaitingMessage();
        }
        this._waiting = true;
        int skipCount = 0;
        if (this._valid == 0) {
            forward = true;
            fromOffset = -1;
            requestedCount = row + 1;
        } else if (row >= this._offset + this._valid) {
            forward = true;
            fromOffset = this._offset + this._valid - 1;
            requestedCount = row - (this._offset + this._valid) + 1;
        } else if (row < this._offset && row > this._offset - row) {
            forward = false;
            requestedCount = this._offset - row;
            fromOffset = this._offset;
        } else {
            forward = true;
            fromOffset = -1;
            requestedCount = row + 1;
        }
        if (requestedCount < 256) {
            requestedCount = 256;
        } else if (requestedCount > 2048) {
            skipCount = requestedCount - 1024;
            requestedCount = 2048;
        }
        Fetcher fetcher = new Fetcher(forward, fromOffset, requestedCount, skipCount);
        new Thread(fetcher).start();
        return this._adminUI.getWaitingMessage();
    }

    private synchronized void receiveData(Fetcher fetcher) {
        int oldOffset;
        this._waiting = false;
        if (fetcher._exception != null) {
            this._adminUI.postException(fetcher._exception);
        }
        if (fetcher._resultRows == null) {
            return;
        }
        if (this._infoArray == null || this._infoArray.length != 2048) {
            this._infoArray = new Object[2048];
            this._offset = 0;
            this._valid = 0;
        }
        int count = fetcher._resultRows.length;
        int newValid = this._valid + count;
        int newOffset = oldOffset = this._offset;
        int oldRowCount = this._currentRowCount;
        int lost = 0;
        int kept = this._valid;
        int cut = 0;
        if (fetcher._forward) {
            if (fetcher._from != this._offset + this._valid - 1) {
                this._valid = 0;
                kept = 0;
                newValid = count;
                newOffset = fetcher._from + 1;
            }
            if (newValid > 2048) {
                lost = newValid - 2048;
                newOffset += lost;
                if (lost < this._valid) {
                    kept = this._valid - lost;
                    System.arraycopy(this._infoArray, lost, this._infoArray, 0, kept);
                } else {
                    cut = lost - this._valid;
                    kept = 0;
                }
                newValid = 2048;
            }
            System.arraycopy(fetcher._resultRows, cut, this._infoArray, kept, count - cut);
            int firstUpdatedRow = newOffset + kept;
            int lastUpdatedRow = firstUpdatedRow + count - cut - 1;
            if (count < fetcher._requestedCount) {
                this.changeRowCount(newOffset + newValid, true);
            }
        } else {
            if (fetcher._from != this._offset) {
                this._valid = 0;
                kept = 0;
                newValid = count;
                newOffset = fetcher._from - count;
            } else {
                newOffset = oldOffset - count;
            }
            if (newValid > 2048) {
                lost = newValid - 2048;
                if (lost < this._valid) {
                    kept = this._valid - lost;
                    System.arraycopy(this._infoArray, 0, this._infoArray, this._valid - kept, kept);
                } else {
                    cut = lost - this._valid;
                    kept = 0;
                }
                newValid = 2048;
            }
            System.arraycopy(fetcher._resultRows, 0, this._infoArray, 0, count - cut);
            int firstUpdatedRow = newOffset;
            int lastUpdatedRow = firstUpdatedRow + count - cut - 1;
            if (count < fetcher._requestedCount) {
                this._definite = false;
                this._currentRowCount = 10000;
                this._offset = 0;
            }
        }
        this._offset = newOffset;
        this._valid = newValid;
        if (!this._definite) {
            int estimatedRowCount = (newOffset + this._valid) * 3;
            int receivedRowCount = newOffset + newValid;
            if (estimatedRowCount - receivedRowCount > 100000) {
                estimatedRowCount = receivedRowCount + 100000;
            }
            if (this._currentRowCount < estimatedRowCount && this._offset + this._valid > this._currentRowCount) {
                this.changeRowCount(estimatedRowCount, false);
            }
        }
        this.fireTableRowsUpdated(0, this._currentRowCount - 1);
    }

    private void changeRowCount(int newRowCount, boolean definite) {
        this._deletingRows = true;
        int oldRowCount = this._currentRowCount;
        this._definite = definite;
        this._currentRowCount = newRowCount;
        if (oldRowCount < newRowCount) {
            this.fireTableRowsInserted(oldRowCount, newRowCount - 1);
        } else if (oldRowCount > newRowCount) {
            this.fireTableRowsDeleted(newRowCount, oldRowCount - 1);
        }
        this._deletingRows = false;
    }

    private class Fetcher
    implements Runnable {
        boolean _forward;
        int _from;
        int _requestedCount;
        int _skipCount;
        Object[] _resultRows;
        Exception _exception;

        Fetcher(boolean forward, int from, int requestedCount, int skipCount) {
            this._forward = forward;
            this._from = from;
            this._requestedCount = requestedCount;
            this._skipCount = skipCount;
        }

        @Override
        public void run() {
            Management.LogicalRecord rec = null;
            if (this._from != -1) {
                rec = (Management.LogicalRecord)ManagementSlidingTableModel.this._infoArray[this._from - ManagementSlidingTableModel.this._offset];
            }
            KeyState ks = rec == null ? KeyState.LEFT_GUARD_KEYSTATE : rec.getKeyState();
            Management management = ManagementSlidingTableModel.this._adminUI.getManagement();
            this._resultRows = new Management.LogicalRecord[0];
            if (management != null) {
                try {
                    Management.LogicalRecordCount lrc;
                    int skipped;
                    if (this._skipCount > 0 && (skipped = (lrc = management.getLogicalRecordCount(ManagementSlidingTableModel.this._volumeName, ManagementSlidingTableModel.this._treeName, ManagementSlidingTableModel.this._keyFilterString, ks, this._forward ? Key.GT : Key.LT, this._skipCount)).getCount()) > 0) {
                        ks = lrc.getKeyState();
                        this._from = this._forward ? this._from + skipped : this._from - skipped;
                    }
                    this._resultRows = management.getLogicalRecordArray(ManagementSlidingTableModel.this._volumeName, ManagementSlidingTableModel.this._treeName, ManagementSlidingTableModel.this._keyFilterString, ks, this._forward ? Key.GT : Key.LT, this._requestedCount, 400, true);
                }
                catch (RemoteException remoteException) {
                    this._exception = remoteException;
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ManagementSlidingTableModel.this.receiveData(Fetcher.this);
                }
            });
        }
    }
}

