/*
 * Decompiled with CFR 0.152.
 */
package com.persistit.ui;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;

class InnerJarClassLoader
extends ClassLoader {
    HashMap _resourceMap = new HashMap();

    InnerJarClassLoader(ClassLoader parent) throws IOException {
        super(parent);
    }

    public void addJar(String jarName) throws IOException {
        this.addJar(this.getClass().getClassLoader().getResourceAsStream(jarName));
    }

    public void addJar(InputStream is) throws IOException {
        ZipEntry entry;
        JarInputStream jis = new JarInputStream(new BufferedInputStream(is, 32768));
        byte[] hbytes = new byte[65536];
        while ((entry = jis.getNextEntry()) != null) {
            int length;
            String name = entry.getName();
            int offset = 0;
            while ((length = jis.read(hbytes, offset, hbytes.length - offset)) != -1) {
                if ((offset += length) != hbytes.length) continue;
                byte[] temp = new byte[hbytes.length + 65536];
                System.arraycopy(hbytes, 0, temp, 0, offset);
                hbytes = temp;
            }
            byte[] bytes = new byte[offset];
            System.arraycopy(hbytes, 0, bytes, 0, offset);
            this._resourceMap.put(name, bytes);
            jis.closeEntry();
        }
    }

    public Class findClass(String className) throws ClassNotFoundException {
        String fileName = className.replace('.', '/') + ".class";
        byte[] bytes = (byte[])this._resourceMap.get(fileName);
        if (bytes != null) {
            return this.defineClass(className, bytes, 0, bytes.length);
        }
        throw new ClassNotFoundException(className);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        byte[] bytes = (byte[])this._resourceMap.get(name);
        if (bytes != null) {
            return new ByteArrayInputStream(bytes);
        }
        return null;
    }
}

