/*
 * Decompiled with CFR 0.152.
 */
package com.persistit.ui;

import com.persistit.Management;
import com.persistit.ui.AdminCommand;
import com.persistit.ui.AdminPanel;
import com.persistit.ui.AdminUI;
import com.persistit.ui.ManagementTableModel;
import com.persistit.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AdminUITaskPanel
extends AdminPanel
implements AdminCommand {
    private static final long serialVersionUID = 1L;
    private static final int FAST_REFRESH_INTERVAL = 1;
    AdminUI _adminUI;
    private static double MAIN_SPLITPANE_RESIZE_WEIGHT = 0.2;
    private ManagementTableModel _taskStatusArrayModel;
    private final Map _menuMap = new TreeMap();
    private boolean _refreshing;
    private JPanel _taskListPanel;
    private JPanel _detailPanel;
    private JTable _taskTable;
    private JTextField _taskIdField;
    private JTextField _descriptionField;
    private JTextField _ownerField;
    private JTextField _stateField;
    private JTextField _startTimeField;
    private JTextField _endTimeField;
    private JTextField _expirationTimeField;
    private JTextArea _statusDetailArea;
    private JTextField _lastExceptionField;
    private JTextArea _messageLogArea;
    private int _savedRefreshInterval;
    private boolean _fastRefreshIntervalSet;
    private long _selectedTaskId = -1L;

    @Override
    protected void setup(AdminUI ui) throws NoSuchMethodException, RemoteException {
        this._adminUI = ui;
        this._taskListPanel = new JPanel(new BorderLayout());
        this._taskStatusArrayModel = new ManagementTableModel(Management.TaskStatus.class, "TaskStatus", ui);
        this._menuMap.put("TASK.1", this._adminUI.createMenuArray(this, "TaskPanelMenu", "TASK"));
        this._taskTable = new JTable(this._taskStatusArrayModel);
        this._taskTable.setAutoCreateRowSorter(true);
        this._taskTable.setPreferredScrollableViewportSize(new Dimension(800, 100));
        this._taskTable.setAutoCreateColumnsFromModel(false);
        this._taskTable.setSelectionMode(2);
        this._taskStatusArrayModel.formatColumns(this._taskTable, null);
        this._taskTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                int[] selectedRows = AdminUITaskPanel.this._taskTable.getSelectedRows();
                if (!lse.getValueIsAdjusting() && !AdminUITaskPanel.this._refreshing) {
                    if (selectedRows.length == 1) {
                        int index = selectedRows[0];
                        Management.TaskStatus[] array = (Management.TaskStatus[])AdminUITaskPanel.this._taskStatusArrayModel.getInfoArray();
                        if (array != null && index < array.length) {
                            AdminUITaskPanel.this.selectTask(array[index]);
                        } else {
                            AdminUITaskPanel.this.selectTask(null);
                        }
                    } else {
                        AdminUITaskPanel.this.selectTask(null);
                    }
                    AdminUITaskPanel.this.setTaskActionEnabledState(selectedRows.length > 0);
                }
            }
        });
        JScrollPane treeScrollPane = new JScrollPane(this._taskTable);
        treeScrollPane.setBorder(null);
        this._taskListPanel.setBorder(this._adminUI.createTitledBorder("TaskPanel.tasks"));
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(new JButton(ui.getAction("START_NEW_TASK")));
        buttonPanel.add(new JButton(ui.getAction("SUSPEND_TASKS")));
        buttonPanel.add(new JButton(ui.getAction("RESUME_TASKS")));
        buttonPanel.add(new JButton(ui.getAction("STOP_TASKS")));
        buttonPanel.add(new JButton(ui.getAction("REMOVE_TASKS")));
        this._taskListPanel.add((Component)treeScrollPane, "Center");
        this._taskListPanel.add((Component)buttonPanel, "South");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(3, 1, 1, 3);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 1;
        this._detailPanel = new JPanel(new GridBagLayout());
        this._detailPanel.setBorder(this._adminUI.createTitledBorder("TaskPanel.taskDetail"));
        this._taskIdField = (JTextField)ui.addLabeledField(this._detailPanel, gbc, new JTextField(), "TaskPanel.taskId", false);
        this._stateField = (JTextField)ui.addLabeledField(this._detailPanel, gbc, new JTextField(), "TaskPanel.state", false);
        this._descriptionField = (JTextField)ui.addLabeledField(this._detailPanel, gbc, new JTextField(), "TaskPanel.description", true);
        this._ownerField = (JTextField)ui.addLabeledField(this._detailPanel, gbc, new JTextField(), "TaskPanel.owner", true);
        this._startTimeField = (JTextField)ui.addLabeledField(this._detailPanel, gbc, new JTextField(), "TaskPanel.startTime", false);
        this._endTimeField = (JTextField)ui.addLabeledField(this._detailPanel, gbc, new JTextField(), "TaskPanel.endTime", false);
        this._expirationTimeField = (JTextField)ui.addLabeledField(this._detailPanel, gbc, new JTextField(), "TaskPanel.expirationTime", true);
        this._lastExceptionField = (JTextField)ui.addLabeledField(this._detailPanel, gbc, new JTextField(), "TaskPanel.lastException", true);
        this._statusDetailArea = (JTextArea)ui.addLabeledField(this._detailPanel, gbc, new JTextArea(), "TaskPanel.statusDetail", true);
        gbc.gridheight = 0;
        gbc.weighty = 1.0;
        this._messageLogArea = (JTextArea)ui.addLabeledField(this._detailPanel, gbc, new JTextArea(), "TaskPanel.messageLog", true);
        JSplitPane mainSplitPane = new JSplitPane(0);
        mainSplitPane.setResizeWeight(MAIN_SPLITPANE_RESIZE_WEIGHT);
        mainSplitPane.add(this._taskListPanel);
        mainSplitPane.add(this._detailPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)mainSplitPane, "Center");
        this.setTaskActionEnabledState(false);
        this._adminUI.registerTextComponent(this._statusDetailArea);
        this._adminUI.registerTextComponent(this._messageLogArea);
        this._adminUI.scheduleRefresh(-1);
    }

    @Override
    public void actionPerformed(AdminUI.AdminAction action, ActionEvent ae) {
        block7: {
            Management management = this._adminUI.getManagement();
            if (management == null) {
                return;
            }
            try {
                String name = action.getName();
                boolean suspend = "SUSPEND_TASKS".equals(name);
                boolean resume = "RESUME_TASKS".equals(name);
                boolean stop = "STOP_TASKS".equals(name);
                boolean remove = "REMOVE_TASKS".equals(name);
                if (suspend || resume || stop || remove) {
                    int index;
                    int[] selectedRows = this._taskTable.getSelectedRows();
                    Management.TaskStatus[] tsArray = new Management.TaskStatus[selectedRows.length];
                    for (index = 0; index < tsArray.length; ++index) {
                        Management.TaskStatus ts;
                        int row = selectedRows[index];
                        tsArray[index] = ts = (Management.TaskStatus)this._taskStatusArrayModel.getValueAt(row, -1);
                    }
                    for (index = 0; index < tsArray.length; ++index) {
                        Management.TaskStatus ts = tsArray[index];
                        long taskId = ts.getTaskId();
                        if (suspend || resume) {
                            management.setTaskSuspended(taskId, suspend);
                            continue;
                        }
                        if (!stop && !remove) continue;
                        management.stopTask(taskId, remove);
                    }
                }
                this._adminUI.scheduleRefresh(-1);
            }
            catch (Exception e) {
                this._adminUI.postException(e);
                if (e instanceof RemoteException) break block7;
                e.printStackTrace();
            }
        }
    }

    private boolean selectTask(Management.TaskStatus taskStatus) {
        this._selectedTaskId = -1L;
        if (taskStatus != null) {
            this._selectedTaskId = taskStatus.getTaskId();
        }
        this.updateDetailedTaskStatus();
        return false;
    }

    private void updateDetailedTaskStatus() {
        Management management = this._adminUI.getManagement();
        if (this._selectedTaskId == -1L || management == null) {
            this.updateDetailedTaskStatus(null);
        } else {
            try {
                Management.TaskStatus[] array = management.queryTaskStatus(this._selectedTaskId, true, false, false);
                if (array.length == 1) {
                    this.updateDetailedTaskStatus(array[0]);
                }
            }
            catch (RemoteException re) {
                this._adminUI.postException(re);
            }
        }
    }

    private void updateDetailedTaskStatus(Management.TaskStatus taskStatus) {
        if (taskStatus == null) {
            this._taskIdField.setText("");
            this._stateField.setText("");
            this._descriptionField.setText("");
            this._ownerField.setText("");
            this._startTimeField.setText("");
            this._endTimeField.setText("");
            this._expirationTimeField.setText("");
            this._lastExceptionField.setText("");
            this._statusDetailArea.setText("");
            this._messageLogArea.setText("");
        } else {
            this._taskIdField.setText(Long.toString(taskStatus.getTaskId()));
            this._stateField.setText(this._adminUI.getTaskStateString(taskStatus.getState()));
            this._descriptionField.setText(taskStatus.getDescription());
            this._ownerField.setText(taskStatus.getOwner());
            this._startTimeField.setText(this._adminUI.formatDate(taskStatus.getStartTime()));
            this._endTimeField.setText(this._adminUI.formatDate(taskStatus.getFinishTime()));
            this._expirationTimeField.setText(this._adminUI.formatDate(taskStatus.getExpirationTime()));
            this._lastExceptionField.setText(taskStatus.getLastException() == null ? "" : taskStatus.getLastException().toString());
            this._statusDetailArea.setText(taskStatus.getStatusDetail());
            StringBuilder sb = new StringBuilder();
            int size = 0;
            if (taskStatus.getMessages() != null) {
                size = taskStatus.getMessages().length;
            }
            for (int index = 0; index < size; ++index) {
                sb.append(taskStatus.getMessages()[index]);
                sb.append(Util.NEW_LINE);
            }
            this._messageLogArea.setText(sb.toString());
        }
    }

    private boolean equals(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    private void setTaskActionEnabledState(boolean enabled) {
        AdminUI.AdminAction action = this._adminUI.getAction("SUSPEND_TASKS");
        if (action != null) {
            action.setEnabled(enabled);
        }
        if ((action = this._adminUI.getAction("RESUME_TASKS")) != null) {
            action.setEnabled(enabled);
        }
        if ((action = this._adminUI.getAction("STOP_TASKS")) != null) {
            action.setEnabled(enabled);
        }
        if ((action = this._adminUI.getAction("REMOVE_TASKS")) != null) {
            action.setEnabled(enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void refresh(boolean reset) {
        AdminUITaskPanel adminUITaskPanel = this;
        synchronized (adminUITaskPanel) {
            if (this._refreshing) {
                return;
            }
            this._refreshing = true;
        }
        try {
            boolean liveTasks = false;
            boolean stillSelected = false;
            Management management = this._adminUI.getManagement();
            if (management != null) {
                Object[] taskStatusArray = management.queryTaskStatus(-1L, false, false, false);
                this._taskStatusArrayModel.setInfoArray(taskStatusArray);
                this.setTaskActionEnabledState(this._taskTable.getSelectedRowCount() > 0);
                for (int index = 0; index < taskStatusArray.length; ++index) {
                    Object ts = taskStatusArray[index];
                    if (((Management.TaskStatus)ts).getState() < 3) {
                        liveTasks = true;
                    }
                    if (((Management.TaskStatus)ts).getTaskId() != this._selectedTaskId) continue;
                    stillSelected = true;
                }
            }
            if (!stillSelected) {
                this.selectTask(null);
            }
            this.updateDetailedTaskStatus();
            this.scheduleFastRefresh(liveTasks);
        }
        catch (RemoteException re) {
            this._adminUI.postException(re);
        }
        finally {
            AdminUITaskPanel adminUITaskPanel2 = this;
            synchronized (adminUITaskPanel2) {
                this._refreshing = false;
            }
        }
    }

    @Override
    public void setIsShowing(boolean isShowing) {
        if (this._fastRefreshIntervalSet) {
            this._adminUI.scheduleRefresh(isShowing ? 1 : this._savedRefreshInterval);
        }
    }

    private void scheduleFastRefresh(boolean liveTasks) {
        if (liveTasks && !this._fastRefreshIntervalSet) {
            this._savedRefreshInterval = this._adminUI.getRefreshInterval();
            this._fastRefreshIntervalSet = true;
            this._adminUI.scheduleRefresh(1);
        } else if (!liveTasks && this._fastRefreshIntervalSet) {
            this._fastRefreshIntervalSet = false;
            this._adminUI.scheduleRefresh(this._savedRefreshInterval);
        }
    }

    @Override
    protected Map getMenuMap() {
        return this._menuMap;
    }

    @Override
    protected void setDefaultButton() {
    }
}

