/*
 * Decompiled with CFR 0.152.
 */
package com.persistit.ui;

import com.persistit.Management;
import com.persistit.ui.AdminCommand;
import com.persistit.ui.AdminPanel;
import com.persistit.ui.AdminUI;
import com.persistit.ui.ManagementTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AdminUISummaryPanel
extends AdminPanel
implements AdminCommand {
    AdminUI _adminUI;
    JPanel _summaryPanel;
    JPanel _journalPanel;
    JPanel _recoveryPanel;
    JPanel _volumeTablePanel;
    JTextField _version;
    JTextField _copyright;
    JTextField _elapsed;
    JTextField _started;
    JTextField _totalReads;
    JTextField _totalWrites;
    JTextField _totalGets;
    JTextField _totalHits;
    JTextField _hitRatio;
    JTextField _commits;
    JTextField _rollbacks;
    JTextField _rollbacksSinceLastCommit;
    JTextField _journalCurLocation;
    JTextField _journalBlockSize;
    JTextField _journalBaseAddress;
    JTextField _journalPageMapSize;
    JTextField _journalPageCount;
    JTextField _journalCopiedPageCount;
    JTextField _journalReadPageCount;
    JTextField _journalValidCkptTime;
    JTextField _journalValidCkptAgo;
    JTextField _journalValidCkptTimestamp;
    JTextField _journalValidCkptLocation;
    JTextField _journalAppendOnly;
    JTextField _journalCopyFast;
    JTextField _frozenUpdates;
    JTextField _frozenShutdown;
    JTextField _recoveryKeystone;
    JTextField _recoveryBaseAddress;
    JTextField _recoveryEndAddress;
    JTextField _recoveryCkptTime;
    JTextField _recoveryCkptTimestamp;
    JTextField _recoveryCkptLocation;
    JTextField _recoveryCommitted;
    JTextField _recoveryUncommitted;
    JTextField _recoveryApplied;
    JTextField _recoveryException;
    JTextField _journalRecoveryLocation;
    String _frozenTrueCaption;
    String _frozenFalseCaption;
    String _enabledCaption;
    String _disabledCaption;
    String _dirtyCaption;
    String _cleanCaption;
    Color _normalForegroundColor;
    JTable _volumeTable;
    ManagementTableModel _volumeInfoArrayModel;
    private final Map _menuMap = new HashMap();
    private String _selectedVolumeName;

    @Override
    protected void setup(AdminUI ui) throws NoSuchMethodException, RemoteException {
        this._adminUI = ui;
        this.setLayout(new BorderLayout());
        this._summaryPanel = new JPanel(new GridBagLayout());
        this._journalPanel = new JPanel(new GridBagLayout());
        this._recoveryPanel = new JPanel(new GridBagLayout());
        this._volumeTablePanel = new JPanel(new BorderLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 1, 1, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 1;
        this._version = (JTextField)ui.addLabeledField(this._summaryPanel, gbc, new JTextField(), "SummaryPanel.version", false);
        this._started = (JTextField)ui.addLabeledField(this._summaryPanel, gbc, new JTextField(), "SummaryPanel.started", false);
        this._elapsed = (JTextField)ui.addLabeledField(this._summaryPanel, gbc, new JTextField(), "SummaryPanel.elapsed", true);
        this._copyright = (JTextField)ui.addLabeledField(this._summaryPanel, gbc, new JTextField(), "SummaryPanel.copyright", true);
        this._totalWrites = (JTextField)ui.addLabeledField(this._summaryPanel, gbc, new JTextField(), "SummaryPanel.writes", false);
        this._totalReads = (JTextField)ui.addLabeledField(this._summaryPanel, gbc, new JTextField(), "SummaryPanel.reads", false);
        this._totalGets = (JTextField)ui.addLabeledField(this._summaryPanel, gbc, new JTextField(), "SummaryPanel.gets", false);
        this._hitRatio = (JTextField)ui.addLabeledField(this._summaryPanel, gbc, new JTextField(), "SummaryPanel.ratio", true);
        this._commits = (JTextField)ui.addLabeledField(this._summaryPanel, gbc, new JTextField(), "SummaryPanel.commits", false);
        this._rollbacks = (JTextField)ui.addLabeledField(this._summaryPanel, gbc, new JTextField(), "SummaryPanel.rollbacks", false);
        this._rollbacksSinceLastCommit = (JTextField)ui.addLabeledField(this._summaryPanel, gbc, new JTextField(), "SummaryPanel.rollbacksSinceLastCommit", true);
        this._frozenUpdates = (JTextField)ui.addLabeledField(this._summaryPanel, gbc, new JTextField(), "SummaryPanel.update_suspended", false);
        this._frozenShutdown = (JTextField)ui.addLabeledField(this._summaryPanel, gbc, new JTextField(), "SummaryPanel.shutdown_suspended", true);
        this._journalCurLocation = (JTextField)ui.addLabeledField(this._journalPanel, gbc, new JTextField(), "JournalPanel.journal_current_location", false);
        this._journalBaseAddress = (JTextField)ui.addLabeledField(this._journalPanel, gbc, new JTextField(), "JournalPanel.journal_base_address", false);
        this._journalBlockSize = (JTextField)ui.addLabeledField(this._journalPanel, gbc, new JTextField(), "JournalPanel.journal_block_size", true);
        this._journalPageMapSize = (JTextField)ui.addLabeledField(this._journalPanel, gbc, new JTextField(), "JournalPanel.journal_page_map_size", false);
        this._journalPageCount = (JTextField)ui.addLabeledField(this._journalPanel, gbc, new JTextField(), "JournalPanel.journal_page_count", false);
        this._journalCopiedPageCount = (JTextField)ui.addLabeledField(this._journalPanel, gbc, new JTextField(), "JournalPanel.journal_copy_count", false);
        this._journalReadPageCount = (JTextField)ui.addLabeledField(this._journalPanel, gbc, new JTextField(), "JournalPanel.journal_read_count", true);
        this._journalValidCkptLocation = (JTextField)ui.addLabeledField(this._journalPanel, gbc, new JTextField(), "JournalPanel.journal_ckpt_location", false);
        this._journalValidCkptTimestamp = (JTextField)ui.addLabeledField(this._journalPanel, gbc, new JTextField(), "JournalPanel.journal_ckpt_timestamp", true);
        this._journalValidCkptTime = (JTextField)ui.addLabeledField(this._journalPanel, gbc, new JTextField(), "JournalPanel.journal_ckpt_time", false);
        this._journalValidCkptAgo = (JTextField)ui.addLabeledField(this._journalPanel, gbc, new JTextField(), "JournalPanel.journal_ckpt_ago", true);
        this._journalAppendOnly = (JTextField)ui.addLabeledField(this._journalPanel, gbc, new JTextField(), "JournalPanel.journal_append_only", false);
        this._journalCopyFast = (JTextField)ui.addLabeledField(this._journalPanel, gbc, new JTextField(), "JournalPanel.journal_copy_fast", true);
        this._recoveryKeystone = (JTextField)ui.addLabeledField(this._recoveryPanel, gbc, new JTextField(), "RecoveryPanel.recovery_location", false);
        this._recoveryBaseAddress = (JTextField)ui.addLabeledField(this._recoveryPanel, gbc, new JTextField(), "RecoveryPanel.recovery_base", false);
        this._recoveryEndAddress = (JTextField)ui.addLabeledField(this._recoveryPanel, gbc, new JTextField(), "RecoveryPanel.recovery_ended", true);
        this._recoveryCkptLocation = (JTextField)ui.addLabeledField(this._recoveryPanel, gbc, new JTextField(), "RecoveryPanel.recovery_ckpt_location", false);
        this._recoveryCkptTimestamp = (JTextField)ui.addLabeledField(this._recoveryPanel, gbc, new JTextField(), "RecoveryPanel.recovery_ckpt_timestamp", false);
        this._recoveryCkptTime = (JTextField)ui.addLabeledField(this._recoveryPanel, gbc, new JTextField(), "RecoveryPanel.recovery_ckpt_time", true);
        this._recoveryCommitted = (JTextField)ui.addLabeledField(this._recoveryPanel, gbc, new JTextField(), "RecoveryPanel.recovery_committed", false);
        this._recoveryUncommitted = (JTextField)ui.addLabeledField(this._recoveryPanel, gbc, new JTextField(), "RecoveryPanel.recovery_uncommitted", false);
        this._recoveryApplied = (JTextField)ui.addLabeledField(this._recoveryPanel, gbc, new JTextField(), "RecoveryPanel.recovery_applied", true);
        this._recoveryException = (JTextField)ui.addLabeledField(this._recoveryPanel, gbc, new JTextField(), "RecoveryPanel.recovery_exception", false);
        this._frozenTrueCaption = this._adminUI.getProperty("SummaryPanel.suspendedTrueCaption");
        this._frozenFalseCaption = this._adminUI.getProperty("SummaryPanel.suspendedFalseCaption");
        this._enabledCaption = this._adminUI.getProperty("SummaryPanel.enabledCaption");
        this._disabledCaption = this._adminUI.getProperty("SummaryPanel.disabledCaption");
        this._dirtyCaption = this._adminUI.getProperty("SummaryPanel.dirtyCaption");
        this._cleanCaption = this._adminUI.getProperty("SummaryPanel.cleanCaption");
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.fill = 17;
        this.add(new JLabel(this._adminUI.getProperty("volumes")));
        this._volumeInfoArrayModel = new ManagementTableModel(Management.VolumeInfo.class, "VolumeInfo", ui);
        final JTable volumeTable = new JTable(this._volumeInfoArrayModel);
        volumeTable.setAutoCreateRowSorter(true);
        volumeTable.setPreferredScrollableViewportSize(new Dimension(800, 60));
        volumeTable.setAutoCreateColumnsFromModel(false);
        volumeTable.setSelectionMode(0);
        this._volumeInfoArrayModel.formatColumns(volumeTable, null);
        volumeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                int index = volumeTable.getSelectedRow();
                if (!lse.getValueIsAdjusting() && index >= 0) {
                    Management.VolumeInfo[] array = (Management.VolumeInfo[])AdminUISummaryPanel.this._volumeInfoArrayModel.getInfoArray();
                    if (array != null && index < array.length) {
                        AdminUISummaryPanel.this._selectedVolumeName = array[index].getName();
                    } else {
                        AdminUISummaryPanel.this._selectedVolumeName = null;
                    }
                    AdminUISummaryPanel.this._adminUI.scheduleRefresh(-1);
                }
            }
        });
        JScrollPane volumeScrollPane = new JScrollPane(volumeTable);
        JPanel volumePanel = new JPanel(new BorderLayout());
        volumePanel.setBorder(this._adminUI.createTitledBorder("SummaryPanel.volumes"));
        volumePanel.add((Component)volumeScrollPane, "Center");
        JSplitPane splitter1 = new JSplitPane(0);
        splitter1.add(volumePanel);
        this._volumeTablePanel.add((Component)splitter1, "Center");
        gbc.gridx = 0;
        gbc.gridy = 0;
        this._normalForegroundColor = this._frozenUpdates.getForeground();
        this._summaryPanel.setBorder(this._adminUI.createTitledBorder("SummaryPanel.status"));
        this._journalPanel.setBorder(this._adminUI.createTitledBorder("JournalPanel.journal_status"));
        this._recoveryPanel.setBorder(this._adminUI.createTitledBorder("RecoveryPanel.recovery_status"));
        JPanel panel = new JPanel(new GridBagLayout());
        gbc.fill = 2;
        panel.add((Component)this._summaryPanel, gbc);
        ++gbc.gridy;
        panel.add((Component)this._journalPanel, gbc);
        ++gbc.gridy;
        panel.add((Component)this._recoveryPanel, gbc);
        this.add((Component)panel, "North");
        this.add((Component)this._volumeTablePanel, "Center");
        this.refresh(false);
    }

    @Override
    public void actionPerformed(AdminUI.AdminAction action, ActionEvent ae) {
    }

    @Override
    protected void refresh(boolean reset) {
        try {
            Management management = this._adminUI.getManagement();
            if (management == null) {
                this._version.setText("");
                this._copyright.setText("");
                this._started.setText("");
                this._elapsed.setText("");
                this._totalReads.setText("");
                this._totalWrites.setText("");
                this._totalGets.setText("");
                this._hitRatio.setText("");
                this._commits.setText("");
                this._rollbacks.setText("");
                this._rollbacksSinceLastCommit.setText("");
                this._journalCurLocation.setText("");
                this._journalBlockSize.setText("");
                this._journalBaseAddress.setText("");
                this._journalPageMapSize.setText("");
                this._journalPageCount.setText("");
                this._journalCopiedPageCount.setText("");
                this._journalReadPageCount.setText("");
                this._journalValidCkptTime.setText("");
                this._journalValidCkptAgo.setText("");
                this._journalValidCkptTimestamp.setText("");
                this._journalValidCkptLocation.setText("");
                this._journalAppendOnly.setText("");
                this._journalCopyFast.setText("");
                this._recoveryApplied.setText("");
                this._recoveryBaseAddress.setText("");
                this._recoveryCkptLocation.setText("");
                this._recoveryCkptTime.setText("");
                this._recoveryCkptTimestamp.setText("");
                this._recoveryCommitted.setText("");
                this._recoveryEndAddress.setText("");
                this._recoveryException.setText("");
                this._recoveryKeystone.setText("");
                this._recoveryUncommitted.setText("");
                this._volumeInfoArrayModel.setInfoArray(null);
            } else {
                this._version.setText(management.getVersion());
                this._copyright.setText(management.getCopyright());
                this._started.setText(this._adminUI.formatDate(management.getStartTime()));
                this._elapsed.setText(this._adminUI.formatTime(management.getElapsedTime()));
                this._frozenUpdates.setText(management.isUpdateSuspended() ? this._frozenTrueCaption : this._frozenFalseCaption);
                this._frozenUpdates.setForeground(management.isUpdateSuspended() ? Color.red : this._normalForegroundColor);
                this._frozenShutdown.setText(management.isShutdownSuspended() ? this._frozenTrueCaption : this._frozenFalseCaption);
                this._frozenShutdown.setForeground(management.isShutdownSuspended() ? Color.red : this._normalForegroundColor);
                Management.JournalInfo jinfo = management.getJournalInfo();
                this._journalCurLocation.setText(this._adminUI.formatFileLocation(jinfo.getCurrentJournalFile(), jinfo.getCurrentJournalAddress()));
                this._journalBlockSize.setText(this._adminUI.formatLong(jinfo.getBlockSize()));
                this._journalBaseAddress.setText(this._adminUI.formatLong(jinfo.getBaseAddress()));
                this._journalPageMapSize.setText(this._adminUI.formatLong(jinfo.getPageMapSize()));
                this._journalPageCount.setText(this._adminUI.formatLong(jinfo.getJournaledPageCount()));
                this._journalCopiedPageCount.setText(this._adminUI.formatLong(jinfo.getCopiedPageCount()));
                this._journalReadPageCount.setText(this._adminUI.formatLong(jinfo.getReadPageCount()));
                if (jinfo.getLastValidCheckpointSystemTime() != 0L) {
                    this._journalValidCkptTime.setText(this._adminUI.formatDate(jinfo.getLastValidCheckpointSystemTime()));
                    this._journalValidCkptAgo.setText(this._adminUI.formatLong(jinfo.getLastValidCheckpointAge()));
                    this._journalValidCkptTimestamp.setText(this._adminUI.formatLong(jinfo.getLastValidCheckpointTimestamp()));
                    this._journalValidCkptLocation.setText(this._adminUI.formatFileLocation(jinfo.getLastValidCheckpointJournalFile(), jinfo.getLastValidCheckpointJournalAddress()));
                }
                this._journalAppendOnly.setText(jinfo.isAppendOnly() ? this._enabledCaption : this._disabledCaption);
                this._journalCopyFast.setText(jinfo.isFastCopying() ? this._enabledCaption : this._disabledCaption);
                Management.RecoveryInfo rinfo = management.getRecoveryInfo();
                this._recoveryApplied.setText(this._adminUI.formatInteger(rinfo.getAppliedTransactions()));
                this._recoveryBaseAddress.setText(this._adminUI.formatLong(rinfo.getBaseAddress()));
                this._recoveryCkptLocation.setText(this._adminUI.formatLong(rinfo.getLastValidCheckpointJournalAddress()));
                this._recoveryCkptTime.setText(this._adminUI.formatDate(rinfo.getLastValidCheckpointSystemTime()));
                this._recoveryCkptTimestamp.setText(this._adminUI.formatLong(rinfo.getLastValidCheckpointTimestamp()));
                this._recoveryCommitted.setText(this._adminUI.formatInteger(rinfo.getCommittedTransactions()));
                this._recoveryEndAddress.setText(this._adminUI.formatLong(rinfo.getRecoveryEndAddress()));
                this._recoveryException.setText(rinfo.getRecoveryEndedException() == null ? "none" : rinfo.getRecoveryEndedException());
                this._recoveryKeystone.setText(this._adminUI.formatFileLocation(rinfo.getKeystoneJournalFile(), rinfo.getKeystoneJournalAddress()));
                this._recoveryUncommitted.setText(this._adminUI.formatInteger(rinfo.getUncommittedTransactions()));
                Management.BufferPoolInfo[] bpia = management.getBufferPoolInfoArray();
                long reads = 0L;
                long writes = 0L;
                long misses = 0L;
                long hits = 0L;
                long creates = 0L;
                for (int index = 0; index < bpia.length; ++index) {
                    misses += bpia[index].getMissCount();
                    hits += bpia[index].getHitCount();
                    creates += bpia[index].getNewCount();
                }
                Object[] via = management.getVolumeInfoArray();
                if (this._selectedVolumeName == null && via.length > 0) {
                    this._selectedVolumeName = via[0].getName();
                }
                for (int index = 0; index < via.length; ++index) {
                    reads += via[index].getReadCounter();
                    writes += via[index].getWriteCounter();
                }
                this._totalReads.setText(this._adminUI.formatLong(reads));
                this._totalWrites.setText(this._adminUI.formatLong(writes));
                this._totalGets.setText(this._adminUI.formatLong(misses));
                this._hitRatio.setText(misses + hits + creates > 0L ? this._adminUI.formatPercent((double)hits / (double)(misses + hits + creates)) : "n/a");
                this._volumeInfoArrayModel.setInfoArray(via);
                Management.TransactionInfo transactionInfo = management.getTransactionInfo();
                this._commits.setText(this._adminUI.formatLong(transactionInfo.getCommitCount()));
                this._rollbacks.setText(this._adminUI.formatLong(transactionInfo.getRollbackCount()));
                this._rollbacksSinceLastCommit.setText(this._adminUI.formatLong(transactionInfo.getRollbackSinceCommitCount()));
            }
        }
        catch (RemoteException re) {
            this._adminUI.postException(re);
        }
    }

    private String formatRecoveryStatus(long status) {
        if (status == Long.MIN_VALUE) {
            return "";
        }
        if (status == -1L) {
            return this._dirtyCaption;
        }
        if (status == 0L) {
            return this._cleanCaption;
        }
        return this._adminUI.formatLong(status);
    }

    @Override
    protected Map getMenuMap() {
        return this._menuMap;
    }

    @Override
    protected void setDefaultButton() {
        this.getRootPane().setDefaultButton(null);
    }
}

