/*
 * Decompiled with CFR 0.152.
 */
package com.persistit.logging;

import com.persistit.logging.PersistitLevel;
import com.persistit.logging.PersistitLogger;
import org.slf4j.Logger;

public class Slf4jAdapter
implements PersistitLogger {
    private final Logger _logger;

    public Slf4jAdapter(Logger logger) {
        this._logger = logger;
    }

    @Override
    public boolean isLoggable(PersistitLevel level) {
        switch (level) {
            case NONE: {
                return false;
            }
            case TRACE: {
                return this._logger.isTraceEnabled();
            }
            case DEBUG: {
                return this._logger.isDebugEnabled();
            }
            case INFO: {
                return this._logger.isInfoEnabled();
            }
            case WARNING: {
                return this._logger.isWarnEnabled();
            }
            case ERROR: {
                return this._logger.isErrorEnabled();
            }
        }
        throw new RuntimeException("base switch");
    }

    @Override
    public void log(PersistitLevel level, String message) {
        switch (level) {
            case NONE: {
                break;
            }
            case TRACE: {
                this._logger.trace(message);
                break;
            }
            case DEBUG: {
                this._logger.debug(message);
                break;
            }
            case INFO: {
                this._logger.info(message);
                break;
            }
            case WARNING: {
                this._logger.warn(message);
                break;
            }
            case ERROR: {
                this._logger.error(message);
                break;
            }
            default: {
                throw new RuntimeException("base switch");
            }
        }
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }
}

