/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.AlertMonitor;
import com.persistit.Buffer;
import com.persistit.MediatedFileChannel;
import com.persistit.Persistit;
import com.persistit.Volume;
import com.persistit.VolumeHeader;
import com.persistit.VolumeSpecification;
import com.persistit.VolumeStatistics;
import com.persistit.VolumeStorage;
import com.persistit.VolumeStructure;
import com.persistit.exception.InUseException;
import com.persistit.exception.InvalidPageAddressException;
import com.persistit.exception.PersistitException;
import com.persistit.exception.PersistitIOException;
import com.persistit.exception.PersistitInterruptedException;
import com.persistit.exception.ReadOnlyVolumeException;
import com.persistit.exception.VolumeAlreadyExistsException;
import com.persistit.exception.VolumeClosedException;
import com.persistit.exception.VolumeFullException;
import com.persistit.exception.VolumeNotFoundException;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;

class VolumeStorageV2
extends VolumeStorage {
    private volatile FileChannel _channel;
    private volatile FileLock _fileLock;
    private volatile Buffer _headBuffer;
    private volatile long _nextAvailablePage;
    private volatile long _extendedPageCount;
    private volatile boolean _opened;
    private volatile boolean _closed;

    VolumeStorageV2(Persistit persistit, Volume volume) {
        super(persistit, volume);
    }

    @Override
    String getPath() {
        return this._volume.getSpecification().getPath();
    }

    @Override
    boolean isReadOnly() {
        return this._volume.getSpecification().isReadOnly();
    }

    @Override
    boolean isTemp() {
        return false;
    }

    @Override
    FileChannel getChannel() {
        return this._channel;
    }

    @Override
    synchronized void create() throws PersistitException {
        if (this._opened) {
            throw new IllegalStateException("Volume " + this + " cannot be reopened");
        }
        if (this.exists()) {
            throw new VolumeAlreadyExistsException(this.getPath());
        }
        try {
            this._channel = new MediatedFileChannel(this.getPath(), "rw");
            this.lockChannel();
            this.truncate();
            this._opened = true;
        }
        catch (IOException ioe) {
            throw new PersistitIOException(ioe);
        }
        finally {
            if (!this._opened) {
                try {
                    this.closeChannel();
                }
                catch (IOException iOException) {}
                if (this.getPath() != null) {
                    this.delete();
                }
            }
        }
    }

    @Override
    synchronized void open() throws PersistitException {
        if (this._opened) {
            throw new IllegalStateException("Volume " + this + " cannot be reopened");
        }
        if (!this.exists()) {
            throw new VolumeNotFoundException(this.getPath());
        }
        VolumeSpecification spec = this._volume.getSpecification();
        VolumeStatistics stat = this._volume.getStatistics();
        VolumeStructure struc = this._volume.getStructure();
        try {
            this._channel = new MediatedFileChannel(this.getPath(), this.isReadOnly() ? "r" : "rw");
            this.lockChannel();
            this._nextAvailablePage = 1L;
            this._volume.setId(spec.getId());
            this._headBuffer = this._volume.getStructure().getPool().get(this._volume, 0L, true, true);
            this._headBuffer.setFixed();
            byte[] bytes = this._headBuffer.getBytes();
            this._nextAvailablePage = VolumeHeader.getNextAvailablePage(bytes);
            this._extendedPageCount = this._channel.size() / (long)this._volume.getStructure().getPageSize();
            long id = VolumeHeader.getId(bytes);
            this._volume.verifyId(id);
            this._volume.setId(id);
            long now = System.currentTimeMillis();
            spec.setInitialPages(VolumeHeader.getInitialPages(bytes));
            spec.setMaximumPages(VolumeHeader.getMaximumPages(bytes));
            spec.setExtensionPages(VolumeHeader.getExtensionPages(bytes));
            stat.setCreateTime(VolumeHeader.getCreateTime(bytes));
            stat.setNextAvailablePage(VolumeHeader.getNextAvailablePage(bytes));
            stat.setLastExtensionTime(VolumeHeader.getLastExtensionTime(bytes));
            stat.setLastReadTime(VolumeHeader.getLastReadTime(bytes));
            stat.setLastWriteTime(VolumeHeader.getLastWriteTime(bytes));
            stat.setOpenTime(now);
            long directoryRootPage = VolumeHeader.getDirectoryRoot(bytes);
            long garbageRootPage = VolumeHeader.getGarbageRoot(bytes);
            struc.init(directoryRootPage, garbageRootPage);
            long globalTimestamp = VolumeHeader.getGlobalTimestamp(bytes);
            stat.setLastGlobalTimestamp(globalTimestamp);
            this.flushMetaData();
            this._opened = true;
        }
        catch (IOException ioe) {
            throw new PersistitIOException(ioe);
        }
        finally {
            if (this._headBuffer != null) {
                if (!this._opened) {
                    this._headBuffer.clearFixed();
                    this._headBuffer.clearValid();
                    this.releaseHeadBuffer();
                    this._headBuffer = null;
                } else {
                    this.releaseHeadBuffer();
                }
            }
        }
    }

    @Override
    boolean exists() throws PersistitException {
        File file = new File(this.getPath());
        return file.exists() && file.isFile();
    }

    @Override
    boolean delete() throws PersistitException {
        File file = new File(this.getPath());
        return file.exists() && file.isFile() && file.delete();
    }

    @Override
    void force() throws PersistitIOException {
        try {
            this._channel.force(true);
        }
        catch (IOException ioe) {
            throw new PersistitIOException(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void close() throws PersistitException {
        if (!this.claim(true)) {
            throw new InUseException("Unable to acquire claim on " + this);
        }
        try {
            if (this._closed) {
                return;
            }
            this._closed = true;
            this._headBuffer = null;
            PersistitException pe = null;
            try {
                FileLock lock = this._fileLock;
                this._fileLock = null;
                if (lock != null) {
                    lock.release();
                }
            }
            catch (Exception e) {
                this._persistit.getLogBase().exception.log(e);
                pe = new PersistitException(e);
            }
            try {
                this.closeChannel();
            }
            catch (Exception e) {
                this._persistit.getLogBase().exception.log(e);
                pe = new PersistitException(e);
            }
            if (pe != null) {
                throw pe;
            }
        }
        finally {
            this.release();
        }
    }

    private void closeChannel() throws IOException {
        FileChannel channel = this._channel;
        this._channel = null;
        if (channel != null) {
            channel.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void truncate() throws PersistitException {
        this._volume.setId(0L);
        this._volume.setId(VolumeStorageV2.generateId());
        VolumeSpecification spec = this._volume.getSpecification();
        VolumeStatistics stat = this._volume.getStatistics();
        VolumeStructure struc = this._volume.getStructure();
        this.resize(1L);
        this.resize(spec.getInitialPages());
        long now = System.currentTimeMillis();
        stat.setCreateTime(now);
        stat.setOpenTime(now);
        this._extendedPageCount = spec.getInitialPages();
        this._nextAvailablePage = 1L;
        this._headBuffer = this._volume.getStructure().getPool().get(this._volume, 0L, true, false);
        boolean truncated = false;
        try {
            this._headBuffer.init(32);
            this._headBuffer.setFixed();
            this.initMetaData(this._headBuffer.getBytes());
            ByteBuffer bb = this._headBuffer.getByteBuffer();
            bb.limit(this._headBuffer.getBufferSize()).position(0);
            this.writePage(bb, this._headBuffer.getPageAddress());
            struc.init(0L, 0L);
            this.flushMetaData();
            truncated = true;
        }
        finally {
            if (!truncated) {
                this._headBuffer.clearValid();
                this._headBuffer.clearFixed();
                this.releaseHeadBuffer();
                this._headBuffer = null;
            } else {
                this.releaseHeadBuffer();
            }
        }
    }

    @Override
    boolean isOpened() {
        return this._opened;
    }

    @Override
    boolean isClosed() {
        return this._closed;
    }

    @Override
    long getExtentedPageCount() {
        return this._extendedPageCount;
    }

    @Override
    long getNextAvailablePage() {
        return this._nextAvailablePage;
    }

    @Override
    void claimHeadBuffer() throws PersistitException {
        if (!this._headBuffer.claim(true)) {
            throw new InUseException("Unable to acquire claim on " + this._headBuffer);
        }
    }

    @Override
    void releaseHeadBuffer() {
        this._headBuffer.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void readPage(Buffer buffer) throws PersistitIOException, InvalidPageAddressException, VolumeClosedException, PersistitInterruptedException, InUseException {
        if (!this.claim(false)) {
            throw new InUseException("Unable to acquire claim on " + this);
        }
        try {
            long page = buffer.getPageAddress();
            if (page < 0L || page >= this._nextAvailablePage) {
                throw new InvalidPageAddressException("Page " + page + " out of bounds [0-" + this._nextAvailablePage + "]");
            }
            if (this._persistit.getJournalManager().readPageFromJournal(buffer)) {
                return;
            }
            try {
                int bytesRead;
                ByteBuffer bb = buffer.getByteBuffer();
                bb.position(0).limit(buffer.getBufferSize());
                for (int read = 0; read < buffer.getBufferSize(); read += bytesRead) {
                    long position = page * (long)this._volume.getStructure().getPageSize() + (long)bb.position();
                    bytesRead = this._channel.read(bb, position);
                    if (bytesRead > 0) continue;
                    throw new PersistitIOException("Unable to read bytes at position " + position + " in " + this);
                }
                this._persistit.getIOMeter().chargeReadPageFromVolume(this._volume, buffer.getPageAddress(), buffer.getBufferSize(), buffer.getIndex());
                this._volume.getStatistics().bumpReadCounter();
            }
            catch (IOException ioe) {
                this._persistit.getAlertMonitor().post(new AlertMonitor.Event(AlertMonitor.AlertLevel.ERROR, this._persistit.getLogBase().readException, ioe, this._volume, page, buffer.getIndex()), "ReadPage");
                throw new PersistitIOException(ioe);
            }
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void writePage(Buffer buffer) throws PersistitException {
        if (!this.claim(false)) {
            throw new InUseException("Unable to acquire claim on " + this);
        }
        try {
            this._persistit.getJournalManager().writePageToJournal(buffer);
        }
        finally {
            this.release();
        }
    }

    @Override
    void writePage(ByteBuffer bb, long page) throws PersistitIOException, InvalidPageAddressException, ReadOnlyVolumeException, VolumeClosedException {
        if (page < 0L || page >= this._nextAvailablePage) {
            throw new InvalidPageAddressException("Page " + page + " out of bounds [0-" + this._nextAvailablePage + "]");
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyVolumeException(this.getPath());
        }
        try {
            this._channel.write(bb, page * (long)this._volume.getStructure().getPageSize());
        }
        catch (IOException ioe) {
            this._persistit.getAlertMonitor().post(new AlertMonitor.Event(AlertMonitor.AlertLevel.ERROR, this._persistit.getLogBase().writeException, ioe, this._volume, page), "WritePage");
            throw new PersistitIOException(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    long allocNewPage() throws PersistitException {
        long page = -1L;
        this.claimHeadBuffer();
        try {
            while (true) {
                if (this._nextAvailablePage < this._extendedPageCount) break;
                this.extend();
            }
            page = this._nextAvailablePage++;
            this._volume.getStatistics().setNextAvailablePage(page);
            this.flushMetaData();
        }
        finally {
            this.releaseHeadBuffer();
        }
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void flush() throws PersistitException {
        this.claimHeadBuffer();
        try {
            this.flushMetaData();
        }
        finally {
            this.releaseHeadBuffer();
        }
    }

    @Override
    void flushMetaData() throws PersistitException {
        if (!this.isReadOnly()) {
            assert (this._headBuffer.isOwnedAsWriterByMe());
            long timestamp = this._persistit.getTimestampAllocator().updateTimestamp();
            this._volume.getStatistics().setLastGlobalTimestamp(timestamp);
            this._headBuffer.writePageOnCheckpoint(timestamp);
            if (this.updateMetaData(this._headBuffer.getBytes())) {
                this._headBuffer.setDirtyAtTimestamp(timestamp);
            }
        }
    }

    @Override
    void extend(long pageAddr) throws PersistitException {
        if (pageAddr >= this._extendedPageCount) {
            this.extend();
            this.flush();
        }
    }

    private void lockChannel() throws InUseException, IOException {
        try {
            this._fileLock = this._channel.tryLock(0L, Long.MAX_VALUE, this.isReadOnly());
        }
        catch (OverlappingFileLockException e) {
            throw new InUseException("Volume file " + this.getPath() + " is locked by another thread in this JVM");
        }
        if (this._fileLock == null) {
            throw new InUseException("Volume file " + this.getPath() + " is locked by another process");
        }
    }

    private void initMetaData(byte[] bytes) {
        VolumeStructure struc = this._volume.getStructure();
        VolumeHeader.putSignature(bytes);
        VolumeHeader.putVersion(bytes);
        VolumeHeader.putPageSize(bytes, struc.getPageSize());
        VolumeHeader.putId(bytes, this._volume.getId());
        VolumeHeader.changeNextAvailablePage(bytes, this._nextAvailablePage);
        VolumeHeader.changeExtendedPageCount(bytes, this._extendedPageCount);
        VolumeHeader.changeCreateTime(bytes, this._volume.getStatistics().getCreateTime());
        VolumeHeader.changeInitialPages(bytes, this._volume.getSpecification().getInitialPages());
        VolumeHeader.changeMaximumPages(bytes, this._volume.getSpecification().getMaximumPages());
        VolumeHeader.changeExtensionPages(bytes, this._volume.getSpecification().getExtensionPages());
    }

    @Override
    boolean updateMetaData(byte[] bytes) {
        VolumeStatistics stat = this._volume.getStatistics();
        VolumeStructure struc = this._volume.getStructure();
        boolean changed = false;
        changed |= VolumeHeader.changeNextAvailablePage(bytes, this._nextAvailablePage);
        changed |= VolumeHeader.changeExtendedPageCount(bytes, this._extendedPageCount);
        changed |= VolumeHeader.changeDirectoryRoot(bytes, struc.getDirectoryRoot());
        changed |= VolumeHeader.changeGarbageRoot(bytes, struc.getGarbageRoot());
        changed |= VolumeHeader.changeFetchCounter(bytes, stat.getFetchCounter());
        changed |= VolumeHeader.changeTraverseCounter(bytes, stat.getTraverseCounter());
        changed |= VolumeHeader.changeStoreCounter(bytes, stat.getStoreCounter());
        changed |= VolumeHeader.changeRemoveCounter(bytes, stat.getRemoveCounter());
        changed |= VolumeHeader.changeReadCounter(bytes, stat.getReadCounter());
        changed |= VolumeHeader.changeLastExtensionTime(bytes, stat.getLastExtensionTime());
        changed |= VolumeHeader.changeLastReadTime(bytes, stat.getLastReadTime());
        VolumeHeader.changeWriteCounter(bytes, stat.getWriteCounter());
        VolumeHeader.changeLastWriteTime(bytes, stat.getLastWriteTime());
        VolumeHeader.changeGlobalTimestamp(bytes, stat.getLastGlobalTimestamp());
        return changed;
    }

    private void extend() throws PersistitException {
        long maximumPages = this._volume.getSpecification().getMaximumPages();
        long extensionPages = this._volume.getSpecification().getExtensionPages();
        if (this._extendedPageCount >= maximumPages || extensionPages <= 0L) {
            throw new VolumeFullException(this + " is full: " + this._extendedPageCount + " pages");
        }
        long pageCount = Math.min(this._extendedPageCount + extensionPages, maximumPages);
        this.resize(pageCount);
    }

    private void resize(long pageCount) throws PersistitException {
        long newSize = pageCount * (long)this._volume.getStructure().getPageSize();
        long currentSize = -1L;
        try {
            currentSize = this._channel.size();
            if (currentSize > newSize) {
                this._persistit.getLogBase().extendLonger.log(this, currentSize, newSize);
            }
            if (currentSize < newSize) {
                ByteBuffer bb = ByteBuffer.allocate(1);
                bb.position(0).limit(1);
                this._channel.write(bb, newSize - 1L);
                this._channel.force(true);
                this._persistit.getLogBase().extendNormal.log(this, currentSize, newSize);
            }
            this._volume.getStatistics().setLastExtensionTime(System.currentTimeMillis());
            this._extendedPageCount = pageCount;
        }
        catch (IOException ioe) {
            this._persistit.getAlertMonitor().post(new AlertMonitor.Event(AlertMonitor.AlertLevel.ERROR, this._persistit.getLogBase().extendException, ioe, this._volume.getName(), currentSize, newSize), "ExtendVolume");
            throw new PersistitIOException(ioe);
        }
    }

    @Override
    public String toString() {
        return this._volume.toString();
    }
}

