/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.Value;
import java.io.Serializable;

public class ValueState
implements Serializable {
    public static final long serialVersionUID = -3715600225940676772L;
    private final byte[] _bytes;
    private final boolean _longRecordMode;
    private int _hashCode = -1;

    public ValueState(Value value) {
        this._longRecordMode = value.isLongRecordMode();
        int length = value.getEncodedSize();
        this._bytes = new byte[length];
        System.arraycopy(value.getEncodedBytes(), 0, this._bytes, 0, length);
    }

    public ValueState(Value value, int truncateSize) {
        this._longRecordMode = value.isLongRecordMode();
        int length = value.getEncodedSize();
        if (length > truncateSize) {
            length = truncateSize;
        }
        this._bytes = new byte[length];
        System.arraycopy(value.getEncodedBytes(), 0, this._bytes, 0, length);
    }

    public void copyTo(Value value) {
        if (value.getMaximumSize() < this._bytes.length) {
            throw new IllegalArgumentException("Too small");
        }
        value.clear();
        value.ensureFit(this._bytes.length);
        System.arraycopy(this._bytes, 0, value.getEncodedBytes(), 0, this._bytes.length);
        value.setEncodedSize(this._bytes.length);
        value.setLongRecordMode(this._longRecordMode);
    }

    public int hashCode() {
        if (this._hashCode < 0) {
            int hashCode = 0;
            for (int index = 0; index < this._bytes.length; ++index) {
                hashCode = hashCode * 17 ^ this._bytes[index] & 0xFF;
            }
            this._hashCode = hashCode & Integer.MAX_VALUE;
        }
        return this._hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Value) {
            Value value = (Value)obj;
            if (value.getEncodedSize() != this._bytes.length) {
                return false;
            }
            byte[] valueBytes = value.getEncodedBytes();
            for (int i = 0; i < this._bytes.length; ++i) {
                if (valueBytes[i] == this._bytes[i]) continue;
                return false;
            }
            return true;
        }
        if (obj instanceof ValueState) {
            ValueState valueState = (ValueState)obj;
            if (valueState._bytes.length != this._bytes.length) {
                return false;
            }
            for (int i = 0; i < this._bytes.length; ++i) {
                if (valueState._bytes[i] == this._bytes[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public byte[] getEncodedBytes() {
        return this._bytes;
    }

    public int getEncodedSize() {
        return this._bytes.length;
    }

    boolean isLongRecordMode() {
        return this._longRecordMode;
    }
}

