/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.CLI;
import com.persistit.Management;
import com.persistit.Task;
import com.persistit.util.Util;

public class TaskCheck
extends Task {
    private String _status = "not started";
    private long _taskId = -1L;
    private boolean _details;
    private boolean _clearMessages;
    private boolean _clearTasks;
    private boolean _stop;
    private boolean _suspend;
    private boolean _resume;

    @CLI.Cmd(value="task")
    static Task createTaskCheckTask(@CLI.Arg(value="taskId|long:-1:-1|Task ID to to check, or -1 for all") long taskId, @CLI.Arg(value="_flag|v|Verbose") boolean verbose, @CLI.Arg(value="_flag|m|Keep previously delivered messages") boolean keepMessages, @CLI.Arg(value="_flag|k|Keep task even if completed") boolean keepTasks, @CLI.Arg(value="_flag|x|Stop the task") boolean stop, @CLI.Arg(value="_flag|u|Suspend the task") boolean suspend, @CLI.Arg(value="_flag|r|Resume the task") boolean resume) throws Exception {
        TaskCheck task = new TaskCheck();
        task._taskId = taskId;
        task._details = verbose;
        task._clearTasks = !keepTasks;
        task._clearMessages = !keepMessages;
        task._stop = stop;
        task._suspend = suspend;
        task._resume = resume;
        return task;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    void setArgs(long taskId, boolean verbose, boolean removeTasks, boolean removeMessages, boolean stop, boolean suspend, boolean resume) {
        this._taskId = taskId;
        this._details = verbose;
        this._clearTasks = removeTasks;
        this._clearMessages = removeMessages;
        this._stop = stop;
        this._suspend = suspend;
        this._resume = resume;
    }

    @Override
    protected void runTask() throws Exception {
        if (this._stop) {
            this._persistit.getManagement().stopTask(this._taskId, false);
        } else if (this._suspend) {
            this._persistit.getManagement().setTaskSuspended(this._taskId, true);
        } else if (this._resume) {
            this._persistit.getManagement().setTaskSuspended(this._taskId, false);
        }
        Management.TaskStatus[] status = this._persistit.getManagement().queryTaskStatus(this._taskId, this._details, this._clearMessages, this._clearTasks);
        StringBuilder sb = new StringBuilder();
        for (Management.TaskStatus ts : status) {
            String s = ts.toString(this._details);
            if (s.isEmpty()) continue;
            if (sb.length() > 0) {
                sb.append(Util.NEW_LINE);
            }
            sb.append(s);
        }
        this._status = sb.toString();
    }

    @Override
    public String getStatus() {
        return this._status;
    }
}

