/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.Key;
import com.persistit.KeyParser;
import com.persistit.Persistit;
import com.persistit.encoding.CoderContext;
import com.persistit.exception.MissingKeySegmentException;
import com.persistit.util.Debug;
import com.persistit.util.Util;

public class KeyFilter {
    public static final Term ALL = new SimpleTerm(null);
    private Term[] _terms;
    private int _minDepth = 0;
    private int _maxDepth = Integer.MAX_VALUE;
    private int _keyPrefixByteCount = 0;
    private boolean _isKeyPrefixFilter = false;

    public KeyFilter() {
        this._terms = new Term[0];
    }

    public KeyFilter(String string) {
        KeyParser parser = new KeyParser(string);
        KeyFilter filter = parser.parseKeyFilter();
        if (filter == null) {
            throw new IllegalArgumentException("Invalid KeyFilter expression");
        }
        this._terms = filter._terms;
        this._minDepth = filter._minDepth;
        this._maxDepth = filter._maxDepth;
    }

    public KeyFilter(Key key) {
        this(key, 0, Integer.MAX_VALUE);
    }

    public KeyFilter(Key key, int minDepth, int maxDepth) {
        this.checkLimits(minDepth, maxDepth);
        int size = 0;
        int index = 0;
        if (key != null) {
            this._terms = new Term[key.getDepth()];
            size = key.getEncodedSize();
        }
        if (key != null && size != 0) {
            int previous;
            this._isKeyPrefixFilter = true;
            int level = 0;
            while ((index = key.nextElementIndex(previous = index)) >= 0) {
                if (level <= minDepth) {
                    this._keyPrefixByteCount += index - previous;
                }
                byte[] bytes = new byte[index - previous];
                System.arraycopy(key.getEncodedBytes(), previous, bytes, 0, bytes.length);
                this._terms[level] = new SimpleTerm(bytes);
                ++level;
            }
        }
        this._minDepth = minDepth;
        this._maxDepth = maxDepth;
    }

    public KeyFilter(Term[] terms) {
        this(terms, 0, Integer.MAX_VALUE);
    }

    public KeyFilter(Term[] terms, int minDepth, int maxDepth) {
        this.checkLimits(minDepth, maxDepth);
        this._terms = terms;
        this._minDepth = minDepth;
        this._maxDepth = maxDepth;
    }

    public KeyFilter append(KeyFilter filter) {
        KeyFilter newFilter = new KeyFilter(this.merge(this._terms, filter._terms));
        int size = this._terms.length;
        newFilter._minDepth = filter._minDepth + size;
        if (Integer.MAX_VALUE - size > filter._maxDepth) {
            newFilter._maxDepth = filter._maxDepth + size;
        }
        return newFilter;
    }

    public KeyFilter append(Term term) {
        Term[] newTerms = new Term[this._terms.length + 1];
        System.arraycopy(this._terms, 0, newTerms, 0, this._terms.length);
        newTerms[this._terms.length] = term;
        return new KeyFilter(newTerms);
    }

    public KeyFilter append(Term[] terms) {
        Term[] newTerms = this.merge(this._terms, terms);
        return new KeyFilter(newTerms);
    }

    public KeyFilter limit(int minDepth, int maxDepth) {
        this.checkLimits(minDepth, maxDepth);
        KeyFilter newFilter = new KeyFilter(this._terms);
        newFilter._minDepth = minDepth;
        newFilter._maxDepth = maxDepth;
        return newFilter;
    }

    private void checkLimits(int minDepth, int maxDepth) {
        if (minDepth < 0) {
            throw new IllegalArgumentException("minDepth (" + minDepth + ") must be >= 0");
        }
        if (minDepth > maxDepth) {
            throw new IllegalArgumentException("minDepth (" + minDepth + ") must be <= maxDepth (" + maxDepth + ")");
        }
    }

    private Term[] merge(Term[] a, Term[] b) {
        int sizeB;
        int sizeA = a == null ? 0 : a.length;
        int n = sizeB = b == null ? 0 : b.length;
        if (sizeA == 0 && b != null) {
            return b;
        }
        if (sizeB == 0 && a != null) {
            return a;
        }
        Term[] terms = new Term[sizeA + sizeB];
        if (sizeA > 0) {
            System.arraycopy(a, 0, terms, 0, sizeA);
        }
        if (sizeB > 0) {
            System.arraycopy(b, 0, terms, sizeA, sizeB);
        }
        return terms;
    }

    public static Term simpleTerm(Object value) {
        return KeyFilter.rangeTerm(value, null, true, true, null);
    }

    public static Term simpleTerm(Object value, CoderContext context) {
        return KeyFilter.rangeTerm(value, null, true, true, context);
    }

    public static Term rangeTerm(Object fromValue, Object toValue) {
        return KeyFilter.rangeTerm(fromValue, toValue, true, true, null);
    }

    public static Term rangeTerm(Object fromValue, Object toValue, CoderContext context) {
        return KeyFilter.rangeTerm(fromValue, toValue, true, true, context);
    }

    public static Term rangeTerm(Object fromValue, Object toValue, boolean leftInclusive, boolean rightInclusive) {
        return KeyFilter.rangeTerm(fromValue, toValue, leftInclusive, rightInclusive, null);
    }

    public static Term rangeTerm(Object fromValue, Object toValue, boolean leftInclusive, boolean rightInclusive, CoderContext context) {
        Key key = new Key((Persistit)null);
        if (fromValue == null) {
            key.appendBefore();
        } else {
            key.append(fromValue, context);
        }
        key.reset();
        byte[] leftBytes = KeyFilter.segmentBytes(key);
        key.clear();
        if (toValue != fromValue && toValue != null) {
            key.append(toValue, context);
            key.reset();
            byte[] rightBytes = KeyFilter.segmentBytes(key);
            if (KeyFilter.compare(leftBytes, rightBytes) > 0) {
                throw new IllegalArgumentException("Start value \"" + fromValue + "\" is after end value \"" + toValue + "\".");
            }
            return new RangeTerm(leftBytes, rightBytes, leftInclusive, rightInclusive);
        }
        return new SimpleTerm(leftBytes);
    }

    public static Term termFromKeySegments(Key fromKey, Key toKey, boolean leftInclusive, boolean rightInclusive) {
        byte[] leftBytes = KeyFilter.segmentBytes(fromKey);
        byte[] rightBytes = KeyFilter.segmentBytes(toKey);
        toKey.nextElementIndex();
        if (leftInclusive && rightInclusive && KeyFilter.compare(leftBytes, rightBytes) == 0) {
            return new SimpleTerm(leftBytes);
        }
        return new RangeTerm(leftBytes, rightBytes, leftInclusive, rightInclusive);
    }

    public static Term orTerm(Term[] terms) {
        return new OrTerm(terms);
    }

    static byte[] segmentBytes(Key key) {
        int from = key.getIndex();
        int to = key.nextElementIndex();
        if (to < 0) {
            to = key.getEncodedSize();
        }
        if (to <= 0) {
            throw new MissingKeySegmentException();
        }
        byte[] bytes = new byte[to - from];
        System.arraycopy(key.getEncodedBytes(), from, bytes, 0, bytes.length);
        return bytes;
    }

    public int size() {
        return this._terms.length;
    }

    public int getMinimumDepth() {
        return this._minDepth;
    }

    public int getMaximumDepth() {
        return this._maxDepth;
    }

    public Term getTerm(int index) {
        return this._terms[index];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        int size = this._terms.length;
        if (this._maxDepth > size && this._maxDepth < 100) {
            size = this._maxDepth;
        }
        for (int index = 0; index < size; ++index) {
            if (index > 0) {
                sb.append(",");
                if (index + 1 == this._minDepth) {
                    sb.append(">");
                }
            }
            if (index >= this._terms.length) {
                sb.append(ALL);
            } else {
                this._terms[index].toString(null, sb);
            }
            if (index + 1 != this._maxDepth) continue;
            sb.append("<");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean selected(Key key) {
        int index = 0;
        int size = key.getEncodedSize();
        byte[] keyBytes = key.getEncodedBytes();
        int level = 0;
        while (index != size) {
            Term term;
            if (level >= this._maxDepth) {
                return false;
            }
            int nextIndex = key.nextElementIndex(index);
            if (nextIndex == -1) {
                nextIndex = key.getEncodedSize();
            }
            Term term2 = term = level < this._terms.length ? this._terms[level] : ALL;
            if (term == null || !term.selected(keyBytes, index, nextIndex - index)) {
                return false;
            }
            index = nextIndex;
            ++level;
        }
        return level >= this._minDepth;
    }

    public boolean next(Key key, Key.Direction direction) {
        return this.next(key, 0, 0, direction == Key.GT || direction == Key.GTEQ, direction == Key.GTEQ || direction == Key.LTEQ);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean next(Key key, int index, int level, boolean forward, boolean eq) {
        int nextIndex;
        block26: {
            boolean isLastKeySegment;
            int size = key.getEncodedSize();
            byte[] bytes = key.getEncodedBytes();
            Term term = level >= this._terms.length ? ALL : this._terms[level];
            Debug.$assert0.t(level < this._maxDepth);
            Debug.$assert0.t(index <= size);
            if (term == null) {
                return false;
            }
            if (forward && size == index && level >= this._minDepth) {
                return true;
            }
            if (size == index) {
                nextIndex = size;
            } else {
                nextIndex = key.nextElementIndex(index);
                if (nextIndex == -1) {
                    nextIndex = size;
                }
            }
            boolean bl = isLastKeySegment = nextIndex == size;
            while (true) {
                block25: {
                    if (term.selected(bytes, index, nextIndex - index)) {
                        if (level + 1 == this._maxDepth) {
                            if (isLastKeySegment) {
                                if (eq || !term.atEdge(bytes, index, nextIndex - index, forward)) {
                                    return true;
                                }
                                break block25;
                            } else {
                                key.setEncodedSize(nextIndex);
                                isLastKeySegment = true;
                                if (key.isSpecial()) {
                                    return true;
                                }
                                if (forward) {
                                    key.nudgeRight();
                                    continue;
                                }
                                if (!eq) {
                                    key.nudgeDeeper();
                                }
                                return true;
                            }
                        }
                        if (level + 1 < this._minDepth ? key.isSegmentSpecial(nextIndex) || (forward || !isLastKeySegment) && this.next(key, nextIndex, level + 1, forward, eq) : (isLastKeySegment ? eq || forward && level + 1 < this._maxDepth || !term.atEdge(bytes, index, nextIndex - index, forward) : key.isSegmentSpecial(nextIndex) || this.next(key, nextIndex, level + 1, forward, eq))) {
                            return true;
                        }
                    }
                }
                key.setEncodedSize(nextIndex);
                if (forward) {
                    if (term.selected(key.getEncodedBytes(), index, nextIndex - index) && !term.atEdge(key.getEncodedBytes(), index, nextIndex - index, forward)) {
                        key.nudgeRight();
                        return true;
                    }
                    if (!term.forward(key, index, nextIndex - index)) {
                        return false;
                    }
                } else {
                    if (term.selected(key.getEncodedBytes(), index, nextIndex - index) && !term.atEdge(key.getEncodedBytes(), index, nextIndex - index, forward)) {
                        key.nudgeLeft();
                        return true;
                    }
                    if (!term.backward(key, index, nextIndex - index)) {
                        return false;
                    }
                }
                nextIndex = size = key.getEncodedSize();
                isLastKeySegment = true;
                if (key.isSpecial()) {
                    return true;
                }
                if (!forward) break block26;
                if (level + 1 >= this._minDepth) break;
            }
            if (!eq) {
                key.nudgeLeft();
            }
            return true;
        }
        if (level + 1 < this._maxDepth) {
            key.appendAfter();
            return this.next(key, nextIndex, level + 1, forward, eq);
        }
        if (!eq) {
            key.nudgeRight();
        }
        return true;
    }

    private static int compare(byte[] a, byte[] b) {
        if (a == b || a == null && b == null) {
            return 0;
        }
        if (a == null && b != null) {
            return Integer.MIN_VALUE;
        }
        if (a != null && b == null) {
            return Integer.MAX_VALUE;
        }
        return KeyFilter.compare(a, 0, a.length, b, 0, b.length);
    }

    private static int compare(byte[] a, int offsetA, int sizeA, byte[] b, int offsetB, int sizeB) {
        int size = Math.min(sizeA, sizeB);
        for (int i = 0; i < size; ++i) {
            if (a[i + offsetA] == b[i + offsetB]) continue;
            if ((a[i + offsetA] & 0xFF) > (b[i + offsetB] & 0xFF)) {
                return 1;
            }
            return -1;
        }
        if (sizeA < sizeB) {
            return -1;
        }
        if (sizeA > sizeB) {
            return 1;
        }
        return 0;
    }

    private static int byteHash(byte[] a) {
        if (a == null) {
            return 0;
        }
        int h = 0;
        for (int i = 0; i < a.length; ++i) {
            h = h * 17 + a[i];
        }
        return h;
    }

    private static void appendDisplayableKeySegment(Key workKey, StringBuilder sb, byte[] bytes, CoderContext context, boolean before, boolean after) {
        if (bytes == null) {
            return;
        }
        System.arraycopy(bytes, 0, workKey.getEncodedBytes(), 0, bytes.length);
        workKey.setEncodedSize(bytes.length);
        if (before && workKey.isBefore() || after && workKey.isAfter()) {
            return;
        }
        try {
            workKey.decodeDisplayable(true, sb, context);
        }
        catch (Exception e) {
            sb.append(e);
            sb.append("(");
            sb.append(Util.hexDump(bytes, 0, bytes.length));
            sb.append(")");
        }
    }

    boolean isKeyPrefixFilter() {
        return this._isKeyPrefixFilter;
    }

    int getKeyPrefixByteCount() {
        return this._keyPrefixByteCount;
    }

    static class OrTerm
    extends Term {
        Term[] _terms;

        OrTerm(Term[] terms) {
            this._terms = new Term[terms.length];
            byte[] previousBytes = null;
            for (int index = 0; index < terms.length; ++index) {
                if (terms[index] instanceof OrTerm) {
                    throw new IllegalArgumentException("Nested OrTerm at index " + index);
                }
                if (index > 0) {
                    if (KeyFilter.compare(previousBytes, terms[index].leftBytes()) > 0) {
                        throw new IllegalArgumentException("Overlapping Term at index " + index);
                    }
                    previousBytes = terms[index].rightBytes();
                }
                this._terms[index] = terms[index];
            }
        }

        @Override
        public void toString(CoderContext context, StringBuilder sb) {
            sb.append("{");
            for (int index = 0; index < this._terms.length; ++index) {
                if (index > 0) {
                    sb.append(',');
                }
                this._terms[index].toString(context, sb);
            }
            sb.append("}");
        }

        public boolean equals(Object object) {
            if (object instanceof OrTerm) {
                OrTerm t = (OrTerm)object;
                if (t.hashCode() != this.hashCode() || t._terms.length != this._terms.length) {
                    return false;
                }
                for (int index = 0; index < this._terms.length; ++index) {
                    if (t._terms[index] == this._terms[index]) continue;
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            if (this._hashCode == -1) {
                for (int index = 0; index < this._terms.length; ++index) {
                    this._hashCode ^= this._terms[index].hashCode();
                }
                this._hashCode &= Integer.MAX_VALUE;
            }
            return this._hashCode;
        }

        @Override
        boolean selected(byte[] keyBytes, int offset, int length) {
            for (int index = 0; index < this._terms.length; ++index) {
                if (!this._terms[index].selected(keyBytes, offset, length)) continue;
                return true;
            }
            return false;
        }

        @Override
        boolean atEdge(byte[] keyBytes, int offset, int length, boolean forward) {
            for (int index = 0; index < this._terms.length; ++index) {
                if (!this._terms[index].selected(keyBytes, offset, length) || !this._terms[index].atEdge(keyBytes, offset, length, forward)) continue;
                return true;
            }
            return false;
        }

        @Override
        boolean forward(Key key, int offset, int length) {
            for (int index = 0; index < this._terms.length; ++index) {
                if (!this._terms[index].forward(key, offset, length)) continue;
                return true;
            }
            return false;
        }

        @Override
        boolean backward(Key key, int offset, int length) {
            int index = this._terms.length;
            while (--index >= 0) {
                if (!this._terms[index].backward(key, offset, length)) continue;
                return true;
            }
            return false;
        }

        @Override
        byte[] leftBytes() {
            return null;
        }

        @Override
        byte[] rightBytes() {
            return null;
        }
    }

    static class RangeTerm
    extends Term {
        private final byte[] _itemFromBytes;
        private final byte[] _itemToBytes;
        private final boolean _leftInclusive;
        private final boolean _rightInclusive;

        RangeTerm(byte[] leftBytes, byte[] rightBytes, boolean leftInclusive, boolean rightInclusive) {
            this._itemFromBytes = leftInclusive ? leftBytes : this.nudgeRight(leftBytes);
            this._itemToBytes = rightInclusive ? rightBytes : this.nudgeLeft(rightBytes);
            this._leftInclusive = leftInclusive;
            this._rightInclusive = rightInclusive;
        }

        public boolean equals(Object object) {
            if (object instanceof RangeTerm) {
                RangeTerm t = (RangeTerm)object;
                boolean result = KeyFilter.compare(this._itemFromBytes, t._itemFromBytes) == 0 && KeyFilter.compare(this._itemToBytes, t._itemToBytes) == 0;
                return result;
            }
            return false;
        }

        public int hashCode() {
            if (this._hashCode == -1) {
                this._hashCode = (KeyFilter.byteHash(this._itemFromBytes) ^ KeyFilter.byteHash(this._itemToBytes)) & Integer.MAX_VALUE;
            }
            return this._hashCode;
        }

        @Override
        public void toString(CoderContext context, StringBuilder sb) {
            boolean allInclusive;
            Key workKey = new Key((Persistit)null);
            boolean bl = allInclusive = this._leftInclusive && this._rightInclusive;
            if (!allInclusive) {
                sb.append(this._leftInclusive ? "[" : "(");
            }
            byte[] from = this._leftInclusive ? this._itemFromBytes : this.unnudgeRight(this._itemFromBytes);
            KeyFilter.appendDisplayableKeySegment(workKey, sb, from, context, true, false);
            sb.append(":");
            byte[] to = this._rightInclusive ? this._itemToBytes : this.unnudgeLeft(this._itemToBytes);
            KeyFilter.appendDisplayableKeySegment(workKey, sb, to, context, false, true);
            if (!allInclusive) {
                sb.append(this._rightInclusive ? "]" : ")");
            }
        }

        @Override
        boolean selected(byte[] keyBytes, int offset, int length) {
            int compare = KeyFilter.compare(keyBytes, offset, length, this._itemFromBytes, 0, this._itemFromBytes.length);
            if (compare < 0) {
                return false;
            }
            compare = KeyFilter.compare(keyBytes, offset, length, this._itemToBytes, 0, this._itemToBytes.length);
            return compare <= 0;
        }

        @Override
        boolean atEdge(byte[] keyBytes, int offset, int length, boolean forward) {
            if (forward) {
                return KeyFilter.compare(keyBytes, offset, length, this._itemToBytes, 0, this._itemToBytes.length) == 0;
            }
            return KeyFilter.compare(keyBytes, offset, length, this._itemFromBytes, 0, this._itemFromBytes.length) == 0;
        }

        @Override
        boolean forward(Key key, int offset, int length) {
            byte[] keyBytes = key.getEncodedBytes();
            int compare = KeyFilter.compare(keyBytes, offset, length, this._itemFromBytes, 0, this._itemFromBytes.length);
            if (compare < 0) {
                System.arraycopy(this._itemFromBytes, 0, keyBytes, offset, this._itemFromBytes.length);
                key.setEncodedSize(offset + this._itemFromBytes.length);
                keyBytes[offset + this._itemFromBytes.length] = 0;
                return true;
            }
            return false;
        }

        @Override
        boolean backward(Key key, int offset, int length) {
            byte[] keyBytes = key.getEncodedBytes();
            int compare = KeyFilter.compare(keyBytes, offset, length, this._itemToBytes, 0, this._itemToBytes.length);
            if (compare > 0) {
                System.arraycopy(this._itemToBytes, 0, keyBytes, offset, this._itemToBytes.length);
                key.setEncodedSize(offset + this._itemToBytes.length);
                keyBytes[offset + this._itemToBytes.length] = 0;
                return true;
            }
            return false;
        }

        @Override
        byte[] leftBytes() {
            return this._itemFromBytes;
        }

        @Override
        byte[] rightBytes() {
            return this._itemToBytes;
        }

        private byte[] nudgeRight(byte[] from) {
            int size = from.length;
            byte[] to = new byte[size];
            System.arraycopy(from, 0, to, 0, size);
            if (size > 1 && to[size - 1] == 0) {
                to[size - 1] = 1;
            }
            return to;
        }

        private byte[] nudgeLeft(byte[] from) {
            byte[] to;
            int size = from.length;
            if (size > 1 && from[size - 1] == 0 && from[size - 2] != 0) {
                to = new byte[size - 1];
                System.arraycopy(from, 0, to, 0, size - 1);
            } else {
                to = new byte[size];
                System.arraycopy(from, 0, to, 0, size);
            }
            return to;
        }

        private byte[] unnudgeRight(byte[] from) {
            int size = from.length;
            byte[] to = new byte[size];
            System.arraycopy(from, 0, to, 0, size);
            if (size > 1 && to[size - 1] == 1) {
                to[size - 1] = 0;
            }
            return to;
        }

        private byte[] unnudgeLeft(byte[] from) {
            byte[] to;
            int size = from.length;
            if (size > 1 && from[size - 1] != 0) {
                to = new byte[size + 1];
                System.arraycopy(from, 0, to, 0, size);
            } else {
                to = from;
            }
            return to;
        }
    }

    static class SimpleTerm
    extends Term {
        private final byte[] _itemBytes;

        SimpleTerm(byte[] bytes) {
            this._itemBytes = bytes;
        }

        public int hashCode() {
            if (this._hashCode == -1) {
                this._hashCode = KeyFilter.byteHash(this._itemBytes) & Integer.MAX_VALUE;
            }
            return this._hashCode;
        }

        public boolean equals(Object object) {
            if (object instanceof SimpleTerm) {
                SimpleTerm t = (SimpleTerm)object;
                return KeyFilter.compare(this._itemBytes, t._itemBytes) == 0;
            }
            return false;
        }

        @Override
        public void toString(CoderContext context, StringBuilder sb) {
            if (this == ALL) {
                sb.append("*");
            } else {
                Key workKey = new Key((Persistit)null);
                KeyFilter.appendDisplayableKeySegment(workKey, sb, this._itemBytes, context, false, false);
            }
        }

        @Override
        boolean selected(byte[] keyBytes, int offset, int length) {
            if (length == 0) {
                return false;
            }
            if (this == ALL) {
                return true;
            }
            if (length != this._itemBytes.length) {
                return false;
            }
            for (int index = 0; index < length; ++index) {
                if (this._itemBytes[index] == keyBytes[offset + index]) continue;
                return false;
            }
            return true;
        }

        @Override
        boolean atEdge(byte[] keyBytes, int offset, int length, boolean forward) {
            return this != ALL;
        }

        @Override
        boolean forward(Key key, int offset, int length) {
            if (this == ALL) {
                if (length == 0) {
                    key.setEncodedSize(offset);
                    key.appendBefore();
                } else if (!key.isSpecial()) {
                    key.nudgeRight();
                }
                return true;
            }
            byte[] keyBytes = key.getEncodedBytes();
            int compare = KeyFilter.compare(keyBytes, offset, length, this._itemBytes, 0, this._itemBytes.length);
            if (compare < 0) {
                System.arraycopy(this._itemBytes, 0, keyBytes, offset, this._itemBytes.length);
                key.setEncodedSize(offset + this._itemBytes.length);
                return true;
            }
            return false;
        }

        @Override
        boolean backward(Key key, int offset, int length) {
            int compare;
            if (this == ALL) {
                if (length == 0) {
                    key.setEncodedSize(offset);
                    key.appendAfter();
                } else if (!key.isSpecial()) {
                    key.nudgeLeft();
                }
                return true;
            }
            byte[] keyBytes = key.getEncodedBytes();
            int n = compare = length == 0 ? 1 : KeyFilter.compare(keyBytes, offset, length, this._itemBytes, 0, this._itemBytes.length);
            if (compare > 0) {
                System.arraycopy(this._itemBytes, 0, keyBytes, offset, this._itemBytes.length);
                key.setEncodedSize(offset + this._itemBytes.length);
                return true;
            }
            return false;
        }

        @Override
        byte[] leftBytes() {
            return this._itemBytes;
        }

        @Override
        byte[] rightBytes() {
            return this._itemBytes;
        }
    }

    public static abstract class Term {
        protected int _hashCode = -1;

        public String toString() {
            return this.toString(null);
        }

        public String toString(CoderContext context) {
            StringBuilder sb = new StringBuilder();
            this.toString(context, sb);
            return sb.toString();
        }

        abstract void toString(CoderContext var1, StringBuilder var2);

        abstract boolean selected(byte[] var1, int var2, int var3);

        abstract boolean atEdge(byte[] var1, int var2, int var3, boolean var4);

        abstract boolean forward(Key var1, int var2, int var3);

        abstract boolean backward(Key var1, int var2, int var3);

        abstract byte[] leftBytes();

        abstract byte[] rightBytes();
    }
}

