/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.Management;
import com.persistit.Persistit;
import com.persistit.mxbeans.BufferPoolMXBean;
import com.persistit.mxbeans.Description;
import java.rmi.RemoteException;

class BufferPoolMXBeanImpl
implements BufferPoolMXBean {
    private static final long MAX_STALE = 5000L;
    private final Persistit _persistit;
    private final int _bufferSize;
    private Management.BufferPoolInfo _recent;

    static String mbeanName(int bufferPoolSize) {
        return "com.persistit:type=Persistit,class=BufferPool." + bufferPoolSize;
    }

    BufferPoolMXBeanImpl(Persistit persistit, int bufferSize) {
        this._persistit = persistit;
        this._bufferSize = bufferSize;
        this._recent = new Management.BufferPoolInfo();
    }

    private Management.BufferPoolInfo recent() {
        long now = System.currentTimeMillis();
        if (this._recent.getAcquisitionTime() < now - 5000L) {
            try {
                Management.BufferPoolInfo[] array;
                for (Management.BufferPoolInfo info : array = this._persistit.getManagement().getBufferPoolInfoArray()) {
                    if (info.getBufferSize() != this._bufferSize) continue;
                    this._recent = info;
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        if (this._recent == null) {
            this._recent = new Management.BufferPoolInfo();
        }
        return this._recent;
    }

    @Override
    @Description(value="The size in bytes of each buffer in this pool")
    public int getBufferSize() {
        return this.recent().getBufferSize();
    }

    @Override
    @Description(value="Return the count of Buffer managed by this pool")
    public int getBufferCount() {
        return this.recent().getBufferCount();
    }

    @Override
    @Description(value="Count of unsuccessful lookup operations that resulted in physical disks")
    public long getMissCount() {
        return this.recent().getMissCount();
    }

    @Override
    @Description(value="Count of successful lookup operations")
    public long getHitCount() {
        return this.recent().getHitCount();
    }

    @Override
    @Description(value="Count of pages newly created")
    public long getNewCount() {
        return this.recent().getNewCount();
    }

    @Override
    @Description(value="Count of pages replaced by other pages")
    public long getEvictCount() {
        return this.recent().getEvictCount();
    }

    @Override
    @Description(value="Count of pages written from this BufferPool")
    public long getWriteCount() {
        return this.recent().getWriteCount();
    }

    @Override
    @Description(value="Count of pages forced to be written due to an update after a checkpoint")
    public long getForcedCheckpointWriteCount() {
        return this.recent().getForcedCheckpointWriteCount();
    }

    @Override
    @Description(value="Count of pages forced to be written when dirty on eviction")
    public long getForcedWriteCount() {
        return this.recent().getForcedWriteCount();
    }

    @Override
    @Description(value="Ratio of hits to total page lookup operations")
    public double getHitRatio() {
        return this.recent().getHitRatio();
    }

    @Override
    @Description(value="Count of valid pages in this pool")
    public int getValidPageCount() {
        return this.recent().getValidPageCount();
    }

    @Override
    @Description(value="The count of dirty pages in this pool")
    public int getDirtyPageCount() {
        return this.recent().getDirtyPageCount();
    }

    @Override
    @Description(value="The count of pages with reader claims")
    public int getReaderClaimedPageCount() {
        return this.recent().getReaderClaimedPageCount();
    }

    @Override
    @Description(value="The count of pages with writer claims")
    public int getWriterClaimedPageCount() {
        return this.recent().getWriterClaimedPageCount();
    }

    @Override
    @Description(value="Earliest timestamp of any dirty page in this >BufferPool")
    public long getEarliestDirtyTimestamp() {
        return this.recent().getEarliestDirtyTimestamp();
    }
}

