/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.gradle;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class SourceCollector
implements FileVisitor<Path> {
    private static final Set<String> EXCLUDED_DIRECTORIES = new HashSet<String>(Arrays.asList(".cache", ".env", ".git", ".gradle", ".jruby", ".m2", ".node_modules", ".npm", ".pycache", ".pytest_cache", ".venv", "bin", "build", "dist", "nbbuild", "nbdist", "out", "target", "tmp"));
    private static final Set<String> EXCLUDED_EXTENSIONS_WITH_JAVA_AND_KOTLIN = Stream.of(".jar", ".war", ".class", ".ear", ".nar", ".DS_Store", ".zip", ".7z", ".rar", ".gz", ".tar", ".xz", ".log", ".bak", ".tmp", ".swp", ".iml", ".ipr", ".iws", ".nib", ".log").map(ext -> ext.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
    private static final Set<String> EXCLUDED_EXTENSIONS_WITHOUT_JAVA_AND_KOTLIN = Stream.concat(EXCLUDED_EXTENSIONS_WITH_JAVA_AND_KOTLIN.stream(), Stream.of(".java", ".jav", ".kt")).map(ext -> ext.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
    private static final Set<String> INCLUDE_EXTENSIONS_FOR_HIDDEN_FILES = Set.of(".bash", ".bat", ".cnf", ".config", ".db", ".env", ".htpasswd", ".json", ".ksh", ".properties", ".ps1", ".settings", ".sh", ".txt", ".xml", ".yaml", ".yml", ".zsh");
    private static final Set<String> INCLUDE_HIDDEN_FILES_KEYWORDS = Set.of(".env.", "access", "cfg", "config", "credential", "history", "id_dsa", "id_ecdsa", "id_ed25519", "id_rsa", "key", "password", "private", "pwd", "secret", "sessions", "token");
    private final Path root;
    private final Set<Path> existingSources;
    private final Set<Path> directoriesToIgnore;
    private final Set<Path> excludedFiles;
    private final Set<String> excludedExtensions;
    private final Set<Path> collectedSources = new HashSet<Path>();

    public Set<Path> getCollectedSources() {
        return this.collectedSources;
    }

    public static Builder builder() {
        return new Builder();
    }

    private SourceCollector(Path root, Set<Path> existingSources, Set<Path> directoriesToIgnore, Set<Path> excludedFiles, boolean shouldCollectJavaAndKotlinSources) {
        this.root = root;
        this.existingSources = existingSources;
        this.directoriesToIgnore = directoriesToIgnore;
        this.excludedFiles = excludedFiles;
        this.excludedExtensions = shouldCollectJavaAndKotlinSources ? EXCLUDED_EXTENSIONS_WITH_JAVA_AND_KOTLIN : EXCLUDED_EXTENSIONS_WITHOUT_JAVA_AND_KOTLIN;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) {
        boolean isHiddenAndTooFarDownTheTree;
        boolean bl = isHiddenAndTooFarDownTheTree = SourceCollector.isHidden(path) && !this.isChildOrGrandChildOfRoot(path);
        if (isHiddenAndTooFarDownTheTree || this.isExcludedDirectory(path) || this.isCoveredByExistingSources(path)) {
            return FileVisitResult.SKIP_SUBTREE;
        }
        return FileVisitResult.CONTINUE;
    }

    private static boolean isHidden(Path path) {
        return StreamSupport.stream(path.spliterator(), true).anyMatch(token -> token.toString().startsWith("."));
    }

    private boolean isChildOrGrandChildOfRoot(Path path) {
        return this.root.equals(path.getParent()) || this.root.equals(path.getParent().getParent());
    }

    private boolean isExcludedDirectory(Path path) {
        String pathAsString = path.getFileName().toString().toLowerCase(Locale.ROOT);
        return EXCLUDED_DIRECTORIES.contains(pathAsString) || this.directoriesToIgnore.contains(path);
    }

    private boolean isCoveredByExistingSources(Path path) {
        return this.existingSources.contains(path);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) {
        block4: {
            block5: {
                if (basicFileAttributes.isSymbolicLink() || this.excludedFiles.contains(path)) break block4;
                if (!this.existingSources.stream().noneMatch((Predicate<Path>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Ljava/nio/file/Path;)Z)((Path)path))) break block4;
                lowerCaseFileName = path.getFileName().toString().toLowerCase(Locale.ROOT);
                if (!SourceCollector.isHidden(path)) break block5;
                if (SourceCollector.INCLUDE_HIDDEN_FILES_KEYWORDS.stream().anyMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.CharSequence ), (Ljava/lang/String;)Z)((String)lowerCaseFileName))) ** GOTO lbl-1000
                if (SourceCollector.INCLUDE_EXTENSIONS_FOR_HIDDEN_FILES.stream().anyMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, endsWith(java.lang.String ), (Ljava/lang/String;)Z)((String)lowerCaseFileName))) lbl-1000:
                // 2 sources

                {
                    v0 = true;
                } else {
                    v0 = isHiddenFileToCollect = false;
                }
                if (isHiddenFileToCollect) {
                    this.collectedSources.add(path);
                }
                break block4;
            }
            if (this.excludedExtensions.stream().noneMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, endsWith(java.lang.String ), (Ljava/lang/String;)Z)((String)lowerCaseFileName))) {
                this.collectedSources.add(path);
            }
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path path, IOException e) throws IOException {
        return null;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path path, IOException e) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    public static class Builder {
        private Path root = null;
        private Set<Path> existingSources = new HashSet<Path>();
        private Set<Path> directoriesToIgnore = new HashSet<Path>();
        private Set<Path> excludedFiles = new HashSet<Path>();
        private boolean shouldCollectJavaAndKotlinSources = false;

        private Builder() {
        }

        public Builder setRoot(Path root) {
            this.root = root;
            return this;
        }

        public Builder setExistingSources(Set<Path> existingSources) {
            this.existingSources = existingSources;
            return this;
        }

        public Builder setDirectoriesToIgnore(Set<Path> directoriesToIgnore) {
            this.directoriesToIgnore = directoriesToIgnore;
            return this;
        }

        public Builder setExcludedFiles(Set<Path> excludedFiles) {
            this.excludedFiles = excludedFiles;
            return this;
        }

        public Builder setShouldCollectJavaAndKotlinSources(boolean shouldCollectJavaAndKotlinSources) {
            this.shouldCollectJavaAndKotlinSources = shouldCollectJavaAndKotlinSources;
            return this;
        }

        public SourceCollector build() {
            if (this.root == null) {
                throw new IllegalStateException("Root path must be set");
            }
            return new SourceCollector(this.root, this.existingSources, this.directoriesToIgnore, this.excludedFiles, this.shouldCollectJavaAndKotlinSources);
        }
    }
}

