/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.gradle;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.util.GradleVersion;
import org.sonarqube.gradle.JavaCompilerConfiguration;

public class SonarUtils {
    private static final Pattern REPORT_PATH_PROPERTY_PATTERN = Pattern.compile("^sonar\\.(coverageReportPaths|([^.]++\\.)++(xml)?reports?paths?)$", 2);
    static final String SONAR_JAVA_SOURCE_PROP = "sonar.java.source";
    static final String SONAR_JAVA_TARGET_PROP = "sonar.java.target";
    static final String SONAR_JAVA_ENABLE_PREVIEW_PROP = "sonar.java.enablePreview";
    private static final Pattern TEST_FILE_PATH_PATTERN = Pattern.compile("(?<!at|con|de|la|pro)test(?!ate|ator|atrix|ament|imonial|imony|iness|y)", 2);

    private SonarUtils() {
    }

    static boolean isAndroidProject(Project project) {
        return project.getPlugins().hasPlugin("com.android.application") || project.getPlugins().hasPlugin("com.android.library") || project.getPlugins().hasPlugin("com.android.test") || project.getPlugins().hasPlugin("com.android.feature") || project.getPlugins().hasPlugin("com.android.dynamic-feature");
    }

    static SourceSetContainer getSourceSets(Project project) {
        GradleVersion gradleVersion = GradleVersion.version((String)project.getGradle().getGradleVersion());
        if (SonarUtils.isCompatibleWithJavaPluginExtension(gradleVersion)) {
            return SonarUtils.getSourceSetsGradle7orGreater(project);
        }
        return SonarUtils.getSourceSetsGradleLegacy(project);
    }

    @Nullable
    private static SourceSetContainer getSourceSetsGradle7orGreater(Project project) {
        JavaPluginExtension javaPluginExtension = (JavaPluginExtension)new DslObject((Object)project).getExtensions().findByType(JavaPluginExtension.class);
        if (javaPluginExtension == null) {
            return null;
        }
        return javaPluginExtension.getSourceSets();
    }

    @Nullable
    private static SourceSetContainer getSourceSetsGradleLegacy(Project project) {
        JavaPluginConvention javaPluginConvention = (JavaPluginConvention)new DslObject((Object)project).getConvention().findPlugin(JavaPluginConvention.class);
        if (javaPluginConvention == null) {
            return null;
        }
        return javaPluginConvention.getSourceSets();
    }

    @Nullable
    public static FileCollection getMainClassPath(Project project) {
        return SonarUtils.getClassPath(project, "main");
    }

    @Nullable
    public static FileCollection getTestClassPath(Project project) {
        return SonarUtils.getClassPath(project, "test");
    }

    @Nullable
    public static FileCollection getClassPath(Project project, String sourceSetName) {
        SourceSetContainer sourceSets = SonarUtils.getSourceSets(project);
        return SonarUtils.getClassPathFromSourceSets(sourceSetName, sourceSets);
    }

    @Nullable
    public static FileCollection getClassPathFromSourceSets(String sourceSetName, @Nullable SourceSetContainer sourceSets) {
        if (sourceSets == null) {
            return null;
        }
        SourceSet sourceSet = (SourceSet)sourceSets.findByName(sourceSetName);
        if (sourceSet == null) {
            return null;
        }
        FileCollection compileClasspath = sourceSet.getCompileClasspath();
        if (compileClasspath == null) {
            return null;
        }
        return compileClasspath;
    }

    static boolean isCompatibleWithJavaPluginExtension(GradleVersion version) {
        return version.getBaseVersion().compareTo(GradleVersion.version((String)"7.0")) >= 0;
    }

    static String capitalize(String word) {
        return Character.toUpperCase(word.charAt(0)) + word.substring(1);
    }

    static String findProjectBaseDir(Map<String, Object> properties) {
        Path rootBaseDir = Paths.get(properties.get("sonar.projectBaseDir").toString(), new String[0]).toAbsolutePath().normalize();
        List allProjectsBaseDir = properties.entrySet().stream().filter(e -> ((String)e.getKey()).endsWith(".projectBaseDir")).map(e -> Paths.get(e.getValue().toString(), new String[0])).collect(Collectors.toList());
        for (Path baseDir : allProjectsBaseDir) {
            Path normalizedBaseDir = baseDir.toAbsolutePath().normalize();
            if (!normalizedBaseDir.getRoot().equals(rootBaseDir.getRoot()) || normalizedBaseDir.startsWith(rootBaseDir)) continue;
            int c1 = normalizedBaseDir.getNameCount();
            int c2 = rootBaseDir.getNameCount();
            Path newBaseDir = rootBaseDir.getRoot();
            for (int i = 0; i < c1 && i < c2 && normalizedBaseDir.getName(i).equals(rootBaseDir.getName(i)); ++i) {
                newBaseDir = newBaseDir.resolve(rootBaseDir.getName(i));
            }
            rootBaseDir = newBaseDir;
        }
        return rootBaseDir.toString();
    }

    static void setMainBinariesProps(Map<String, Object> properties, Collection<File> mainClassDirs, boolean addForGroovy) {
        SonarUtils.appendProps(properties, "sonar.java.binaries", SonarUtils.exists(mainClassDirs));
        if (addForGroovy) {
            SonarUtils.appendProps(properties, "sonar.groovy.binaries", SonarUtils.exists(mainClassDirs));
        }
        SonarUtils.appendProps(properties, "sonar.binaries", SonarUtils.exists(mainClassDirs));
    }

    static void populateJdkProperties(Map<String, Object> properties, JavaCompilerConfiguration config) {
        config.getJdkHome().ifPresent(s -> properties.put("sonar.java.jdkHome", s));
        Optional<String> release = config.getRelease();
        if (release.isPresent()) {
            properties.put(SONAR_JAVA_SOURCE_PROP, release.get());
            properties.put(SONAR_JAVA_TARGET_PROP, release.get());
        } else {
            config.getSource().ifPresent(s -> properties.put(SONAR_JAVA_SOURCE_PROP, s));
            config.getTarget().ifPresent(t -> properties.put(SONAR_JAVA_TARGET_PROP, t));
        }
        properties.put(SONAR_JAVA_ENABLE_PREVIEW_PROP, config.getEnablePreview());
    }

    static List<File> exists(Iterable<File> files) {
        ArrayList<File> list = new ArrayList<File>();
        for (File file : files) {
            if (list.contains(file) || !file.exists()) continue;
            list.add(file);
        }
        return list;
    }

    static void appendProps(Map<String, Object> properties, String key, Iterable<?> valuesToAppend) {
        LinkedHashSet<Object> newList = new LinkedHashSet<Object>();
        Object previousValue = properties.get(key);
        if (previousValue instanceof Collection) {
            newList.addAll((Collection)previousValue);
        } else if (previousValue != null) {
            newList.add(previousValue);
        }
        for (Object value : valuesToAppend) {
            newList.add(value);
        }
        properties.put(key, newList);
    }

    static void appendSourcesProp(Map<String, Object> properties, Iterable<File> filesToAppend, boolean testSources) {
        List<File> filteredList = SonarUtils.filterOutSubFiles(filesToAppend);
        SonarUtils.appendProps(properties, testSources ? "sonar.tests" : "sonar.sources", filteredList);
    }

    static List<File> filterOutSubFiles(Iterable<File> files) {
        return StreamSupport.stream(files.spliterator(), false).filter(file -> {
            for (File other : files) {
                if (file.equals(other) || !file.getAbsolutePath().startsWith(other.getAbsolutePath())) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }

    static void appendProp(Map<String, Object> properties, String key, Object valueToAppend) {
        properties.putIfAbsent(key, new LinkedHashSet());
        ((Collection)properties.get(key)).add(valueToAppend);
    }

    @Nullable
    public static <T> List<T> nonEmptyOrNull(Collection<T> collection) {
        List<T> list = Collections.unmodifiableList(new ArrayList<T>(collection));
        return list.isEmpty() ? null : list;
    }

    public static String joinCsvStringsWithoutDuplicates(String csv1, String csv2) {
        List<String> list1 = SonarUtils.splitAsCsv(csv1);
        List<String> list2 = SonarUtils.splitAsCsv(csv2);
        LinkedHashSet<String> resultSet = new LinkedHashSet<String>();
        resultSet.addAll(list1);
        resultSet.addAll(list2);
        return SonarUtils.joinAsCsv(resultSet.stream().filter(s -> !s.isBlank()).collect(Collectors.toList()));
    }

    public static String joinAsCsv(List<String> values) {
        return values.stream().map(SonarUtils::escapeCommas).collect(Collectors.joining(","));
    }

    private static String escapeCommas(String value) {
        return value.contains(",") ? "\"" + value + "\"" : value;
    }

    public static List<String> splitAsCsv(String joined) {
        ArrayList<String> collected = new ArrayList<String>();
        if (joined.indexOf(34) == -1) {
            return Arrays.asList(joined.split(","));
        }
        int start = 0;
        int end = joined.length() - 1;
        while (start < end && end < joined.length()) {
            if (joined.charAt(start) == '\"') {
                end = joined.indexOf(34, start + 1);
                String value = joined.substring(start + 1, end);
                collected.add(value);
                int nextComma = joined.indexOf(",", end);
                if (nextComma == -1) break;
                start = nextComma + 1;
            } else {
                int nextComma = joined.indexOf(",", start);
                end = nextComma == -1 ? joined.length() : nextComma;
                String value = joined.substring(start, end);
                collected.add(value);
                start = end + 1;
            }
            end = start + 1;
        }
        return collected;
    }

    public static Set<Path> extractReportPaths(Map<String, Object> properties) {
        return properties.entrySet().stream().filter(entry -> SonarUtils.isReportPathProperty((String)entry.getKey())).map(Map.Entry::getValue).filter(String.class::isInstance).map(String.class::cast).map(SonarUtils::splitAsCsv).flatMap(Collection::stream).map(String::trim).map(x$0 -> Path.of(x$0, new String[0])).collect(Collectors.toSet());
    }

    public static Set<Path> computeReportPaths(Map<String, Object> properties) {
        if (!properties.containsKey("sonar.projectBaseDir")) {
            throw new IllegalStateException("Cannot compute absolute paths for reports because \"sonar.projectBaseDir\" is not defined.");
        }
        Path projectBaseDir = Path.of(SonarUtils.findProjectBaseDir(properties), new String[0]);
        return SonarUtils.extractReportPaths(properties).stream().map(originalPath -> originalPath.isAbsolute() ? originalPath : projectBaseDir.resolve((Path)originalPath)).collect(Collectors.toSet());
    }

    private static boolean isReportPathProperty(String propertyName) {
        return REPORT_PATH_PROPERTY_PATTERN.matcher(propertyName.trim()).matches();
    }

    public static InputFileType findProjectFileType(Path projectDir, Path filePath) {
        String relativePath = projectDir.relativize(filePath).toString();
        return TEST_FILE_PATH_PATTERN.matcher(relativePath).find() ? InputFileType.TEST : InputFileType.MAIN;
    }

    public static String constructPrefixedProjectName(String projectPath) {
        String[] parts = projectPath.split(":");
        parts = (String[])Arrays.stream(parts).filter(s -> !s.isBlank()).toArray(String[]::new);
        StringBuilder result = new StringBuilder(":");
        for (int i = 0; i < parts.length - 1; ++i) {
            for (int j = 0; j <= i; ++j) {
                result.append(parts[j]);
                if (j >= i) continue;
                result.append(":");
            }
            result.append(".:");
        }
        result.append(projectPath.substring(1));
        return result.toString();
    }

    public static Collection<File> getRuntimeJars() {
        try {
            return Stream.of(SonarUtils.getRuntimeJar(), SonarUtils.getFxRuntimeJar()).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Nullable
    private static File getRuntimeJar() throws IOException {
        File javaBase = new File(System.getProperty("java.home")).getCanonicalFile();
        return Stream.of(new File(javaBase, "lib/rt.jar"), new File(javaBase, "jre/lib/rt.jar")).filter(File::exists).findFirst().orElse(null);
    }

    @Nullable
    private static File getFxRuntimeJar() throws IOException {
        File javaBase = new File(System.getProperty("java.home")).getCanonicalFile();
        return Stream.of(new File(javaBase, "lib/ext/jfxrt.jar"), new File(javaBase, "jre/lib/ext/jfxrt.jar")).filter(File::exists).findFirst().orElse(null);
    }

    public static enum InputFileType {
        MAIN,
        TEST;

    }
}

