/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.gradle;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.VisibleForTesting;
import org.sonarqube.gradle.AnalysisException;
import org.sonarqube.gradle.ProjectProperties;
import org.sonarqube.gradle.ResolutionSerializer;
import org.sonarqube.gradle.SonarUtils;
import org.sonarsource.scanner.lib.ScannerEngineBootstrapResult;
import org.sonarsource.scanner.lib.ScannerEngineBootstrapper;
import org.sonarsource.scanner.lib.ScannerEngineFacade;
import org.sonarsource.scanner.lib.internal.batch.LogOutput;

public class SonarTask
extends ConventionTask {
    private static final Logger LOGGER = Logging.getLogger(SonarTask.class);
    private LogOutput logOutput = new DefaultLogOutput();
    private Provider<Map<String, String>> properties;
    private List<File> resolverFiles;

    @TaskAction
    public void run() {
        Map<String, String> mapProperties;
        SonarTask.logEnvironmentInformation();
        if ("sonarqube".equals(this.getName())) {
            LOGGER.warn("Task 'sonarqube' is deprecated. Use 'sonar' instead.");
        }
        if ((mapProperties = (HashMap<String, String>)this.getProperties().get()).isEmpty()) {
            LOGGER.warn("Skipping Sonar analysis: no properties configured, was it skipped in all projects?");
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            mapProperties = new HashMap<String, String>(mapProperties);
            mapProperties.put("sonar.verbose", "true");
            mapProperties = Collections.unmodifiableMap(mapProperties);
        }
        if (SonarTask.isSkippedWithProperty(mapProperties)) {
            return;
        }
        mapProperties = this.resolveJavaLibraries(mapProperties);
        ScannerEngineBootstrapper scanner = ScannerEngineBootstrapper.create((String)"ScannerGradle", (String)(SonarTask.getPluginVersion() + "/" + String.valueOf(GradleVersion.current()))).addBootstrapProperties(mapProperties);
        try (ScannerEngineBootstrapResult boostrapping = scanner.bootstrap();){
            if (!boostrapping.isSuccessful()) {
                throw new AnalysisException("The scanner boostrapping has failed! See the logs for more details.");
            }
            try (ScannerEngineFacade engineFacade = boostrapping.getEngineFacade();){
                boolean analysisIsSuccessful = engineFacade.analyze(new HashMap());
                if (!analysisIsSuccessful) {
                    throw new AnalysisException("The analysis has failed! See the logs for more details.");
                }
            }
        }
        catch (AnalysisException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AnalysisException(e);
        }
    }

    private static void logEnvironmentInformation() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("org.sonarqube Gradle plugin {}", (Object)SonarTask.getPluginVersion());
            LOGGER.info("Java {} {} ({}-bit)", new Object[]{System.getProperty("java.version"), System.getProperty("java.vm.vendor"), System.getProperty("sun.arch.data.model")});
            LOGGER.info("{} {} ({})", new Object[]{System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch")});
            String gradleOptions = System.getenv("GRADLE_OPTS");
            if (gradleOptions != null) {
                LOGGER.info("GRADLE_OPTS={}", (Object)gradleOptions);
            }
        }
    }

    private static String getPluginVersion() {
        String string;
        InputStream inputStream = SonarTask.class.getResourceAsStream("/org/sonarqube/gradle/sonarqube-gradle-plugin-version.txt");
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        try {
            string = reader.readLine();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.warn("Failed to find the version of the plugin", (Throwable)e);
                return "";
            }
        }
        reader.close();
        return string;
    }

    private static boolean isSkippedWithProperty(Map<String, String> properties) {
        if ("true".equalsIgnoreCase(properties.getOrDefault("sonar.skip", "false"))) {
            LOGGER.warn("Sonar Scanner analysis skipped");
            return true;
        }
        return false;
    }

    @Input
    public Provider<Map<String, String>> getProperties() {
        return this.properties;
    }

    @InputFiles
    public List<File> getResolverFiles() {
        return this.resolverFiles;
    }

    public void setResolverFiles(List<File> resolverFiles) {
        this.resolverFiles = resolverFiles;
    }

    Map<String, String> resolveJavaLibraries(Map<String, String> properties) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Resolving classpath entries");
        }
        HashMap<String, String> result = new HashMap<String, String>(properties);
        LOGGER.info("About to look at resolver files: {}", this.getResolverFiles());
        for (File resolverFile : this.getResolverFiles()) {
            SonarTask.processResolverFile(resolverFile, result);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Finished resolving classpath entries");
        }
        return result;
    }

    @VisibleForTesting
    static void processResolverFile(File resolverFile, Map<String, String> result) {
        LOGGER.info("Looking at file: {}", (Object)resolverFile);
        try {
            Optional<ProjectProperties> prop = ResolutionSerializer.read(resolverFile);
            if (prop.isEmpty()) {
                return;
            }
            ProjectProperties resolvedProperties = prop.get();
            List<File> libraries = resolvedProperties.compileClasspath.stream().map(File::new).collect(Collectors.toList());
            if (resolvedProperties.mainLibraries != null && !resolvedProperties.mainLibraries.isEmpty()) {
                List mainLibraries = resolvedProperties.mainLibraries.stream().map(File::new).collect(Collectors.toList());
                libraries.addAll(mainLibraries);
            }
            SonarTask.resolveSonarJavaLibraries(resolvedProperties, libraries, result);
            List<File> testLibraries = resolvedProperties.testCompileClasspath.stream().map(File::new).collect(Collectors.toList());
            if (resolvedProperties.testLibraries != null && !resolvedProperties.testLibraries.isEmpty()) {
                List testLibs = resolvedProperties.testLibraries.stream().map(File::new).collect(Collectors.toList());
                testLibraries.addAll(testLibs);
            }
            SonarTask.resolveSonarJavaTestLibraries(resolvedProperties, testLibraries, result);
        }
        catch (IOException e) {
            LOGGER.warn("Could not read from resolver file {}", (Object)resolverFile, (Object)e);
        }
    }

    static void resolveSonarJavaLibraries(ProjectProperties projectProperties, @Nullable Iterable<File> mainClassPath, Map<String, String> properties) {
        boolean isTopLevelProject = projectProperties.isRootProject;
        if (LOGGER.isDebugEnabled()) {
            if (isTopLevelProject) {
                LOGGER.debug("Resolving main class path for top-level project.");
            } else {
                LOGGER.debug("Resolving main class path for {}.", (Object)projectProperties.projectName);
            }
        }
        if (mainClassPath == null) {
            LOGGER.debug("No main class path configured. Skipping resolution.");
            return;
        }
        List<File> resolvedLibraries = SonarUtils.exists(mainClassPath);
        String resolvedAsAString = resolvedLibraries.stream().filter(File::exists).map(File::getAbsolutePath).collect(Collectors.joining(","));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Resolved configured main class path as: {}", (Object)resolvedAsAString);
        }
        String propertyKey = isTopLevelProject ? "sonar.java.libraries" : projectProperties.projectName + ".sonar.java.libraries";
        String legacyPropertyKey = isTopLevelProject ? "sonar.libraries" : projectProperties.projectName + ".sonar.libraries";
        Object libraries = properties.getOrDefault(propertyKey, "");
        libraries = ((String)libraries).isEmpty() ? resolvedAsAString : (String)libraries + "," + resolvedAsAString;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Resolved {} as: {}", (Object)propertyKey, libraries);
        }
        properties.put(propertyKey, (String)libraries);
        properties.put(legacyPropertyKey, (String)libraries);
    }

    static void resolveSonarJavaTestLibraries(ProjectProperties projectProperties, @Nullable Iterable<File> testClassPath, Map<String, String> properties) {
        String propertyKey;
        boolean isTopLevelProject = projectProperties.isRootProject;
        if (LOGGER.isDebugEnabled()) {
            if (isTopLevelProject) {
                LOGGER.debug("Resolving test class path for top-level project.");
            } else {
                LOGGER.debug("Resolving test class path for {}.", (Object)projectProperties.projectName);
            }
        }
        if (testClassPath == null) {
            LOGGER.debug("No test class path configured. Skipping resolution.");
            return;
        }
        List<File> resolvedLibraries = SonarUtils.exists(testClassPath);
        String resolvedAsAString = resolvedLibraries.stream().filter(File::exists).map(File::getAbsolutePath).collect(Collectors.joining(","));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Resolved configured test class path as: {}", (Object)resolvedAsAString);
        }
        String binariesPropertyKey = isTopLevelProject ? "sonar.java.binaries" : projectProperties.projectName + ".sonar.java.binaries";
        Object libraries = properties.getOrDefault(binariesPropertyKey, "");
        String string = propertyKey = isTopLevelProject ? "sonar.java.test.libraries" : projectProperties.projectName + ".sonar.java.test.libraries";
        if (properties.containsKey(propertyKey)) {
            libraries = ((String)libraries).isEmpty() ? properties.get(propertyKey) : (String)libraries + "," + properties.get(propertyKey);
        }
        libraries = ((String)libraries).isEmpty() ? resolvedAsAString : SonarUtils.joinCsvStringsWithoutDuplicates((String)libraries, resolvedAsAString);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Resolved {} as: {}", (Object)propertyKey, libraries);
        }
        properties.put(propertyKey, (String)libraries);
    }

    void setProperties(Provider<Map<String, String>> properties) {
        this.properties = properties;
    }

    public void useLoggerLevel(LogLevel logLevel) {
        LogOutput.Level internalLevel = LogOutput.Level.valueOf((String)logLevel.name());
        this.logOutput = new LifecycleLogOutput(internalLevel);
    }

    @Internal
    public LogOutput getLogOutput() {
        return this.logOutput;
    }

    public void setLogOutput(LogOutput logOutput) {
        this.logOutput = logOutput;
    }

    private static class DefaultLogOutput
    implements LogOutput {
        private DefaultLogOutput() {
        }

        public void log(String formattedMessage, LogOutput.Level level) {
            switch (level) {
                case TRACE: {
                    LOGGER.trace(formattedMessage);
                    return;
                }
                case DEBUG: {
                    LOGGER.debug(formattedMessage);
                    return;
                }
                case INFO: {
                    LOGGER.info(formattedMessage);
                    return;
                }
                case WARN: {
                    LOGGER.warn(formattedMessage);
                    return;
                }
                case ERROR: {
                    LOGGER.error(formattedMessage);
                    return;
                }
            }
            throw new IllegalArgumentException(level.name());
        }
    }

    private static class LifecycleLogOutput
    implements LogOutput {
        private final LogOutput.Level logLevel;

        public LifecycleLogOutput(LogOutput.Level logLevel) {
            this.logLevel = logLevel;
        }

        public void log(String formattedMessage, LogOutput.Level level) {
            if (level.ordinal() <= this.logLevel.ordinal()) {
                LOGGER.lifecycle(formattedMessage);
            }
        }
    }
}

