/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.gradle;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Optional;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.sonarqube.gradle.ProjectProperties;

public class ResolutionSerializer {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Logger LOGGER = Logging.getLogger(ResolutionSerializer.class);

    private ResolutionSerializer() {
    }

    public static Optional<ProjectProperties> read(File input) throws IOException {
        if (!input.exists()) {
            return Optional.empty();
        }
        try (FileReader reader = new FileReader(input, StandardCharsets.UTF_8);){
            ProjectProperties projectProperties = (ProjectProperties)GSON.fromJson((Reader)reader, ProjectProperties.class);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Read project properties from file: {}", (Object)input.getAbsolutePath());
            }
            Optional<ProjectProperties> optional = Optional.of(projectProperties);
            return optional;
        }
    }

    public static void write(File output, ProjectProperties properties) throws IOException {
        if (properties.compileClasspath.isEmpty() && properties.testCompileClasspath.isEmpty() && properties.mainLibraries.isEmpty() && properties.testLibraries.isEmpty()) {
            Files.deleteIfExists(output.toPath());
            return;
        }
        try (FileWriter writer = new FileWriter(output, StandardCharsets.UTF_8);){
            GSON.toJson((Object)properties, (Appendable)writer);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Wrote project properties to file: {}", (Object)output.getAbsolutePath());
            }
        }
    }
}

