/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.api.internal;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.sonarsource.scanner.api.internal.cache.Logger;
import org.sonarsource.scanner.api.internal.shaded.okhttp.ConnectionSpec;
import org.sonarsource.scanner.api.internal.shaded.okhttp.Credentials;
import org.sonarsource.scanner.api.internal.shaded.okhttp.OkHttpClient;

public class OkHttpClientFactory {
    static final int CONNECT_TIMEOUT_MILLISECONDS = 5000;
    static final int READ_TIMEOUT_MILLISECONDS = 60000;
    static final String NONE = "NONE";
    static final String P11KEYSTORE = "PKCS11";

    private OkHttpClientFactory() {
    }

    static OkHttpClient create(Logger logger) {
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder();
        okHttpClientBuilder.connectTimeout(5000L, TimeUnit.MILLISECONDS);
        okHttpClientBuilder.readTimeout(60000L, TimeUnit.MILLISECONDS);
        ConnectionSpec tls = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).allEnabledTlsVersions().allEnabledCipherSuites().supportsTlsExtensions(true).build();
        okHttpClientBuilder.connectionSpecs(Arrays.asList(tls, ConnectionSpec.CLEARTEXT));
        X509TrustManager systemDefaultTrustManager = OkHttpClientFactory.systemDefaultTrustManager();
        okHttpClientBuilder.sslSocketFactory(OkHttpClientFactory.systemDefaultSslSocketFactory(systemDefaultTrustManager, logger), systemDefaultTrustManager);
        String proxyUser = System.getProperty("http.proxyUser", "");
        if (!System.getProperty("http.proxyHost", "").isEmpty() && !proxyUser.isEmpty()) {
            okHttpClientBuilder.proxyAuthenticator((route, response) -> {
                if (407 == response.code()) {
                    String credential = Credentials.basic(proxyUser, System.getProperty("http.proxyPassword"));
                    return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                }
                return null;
            });
        }
        return okHttpClientBuilder.build();
    }

    private static X509TrustManager systemDefaultTrustManager() {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            Object[] trustManagers = trustManagerFactory.getTrustManagers();
            if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
                throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
            }
            return (X509TrustManager)trustManagers[0];
        }
        catch (GeneralSecurityException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static SSLSocketFactory systemDefaultSslSocketFactory(X509TrustManager trustManager, Logger logger) {
        KeyManager[] defaultKeyManager = OkHttpClientFactory.getDefaultKeyManager(logger);
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(defaultKeyManager, new TrustManager[]{trustManager}, null);
            return sslContext.getSocketFactory();
        }
        catch (GeneralSecurityException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static synchronized KeyManager[] getDefaultKeyManager(Logger logger) {
        String defaultKeyStore = System.getProperty("javax.net.ssl.keyStore", "");
        String defaultKeyStoreType = System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType());
        String defaultKeyStoreProvider = System.getProperty("javax.net.ssl.keyStoreProvider", "");
        logger.debug("keyStore is : " + defaultKeyStore);
        logger.debug("keyStore type is : " + defaultKeyStoreType);
        logger.debug("keyStore provider is : " + defaultKeyStoreProvider);
        if (P11KEYSTORE.equals(defaultKeyStoreType) && !NONE.equals(defaultKeyStore)) {
            throw new IllegalArgumentException("if keyStoreType is PKCS11, then keyStore must be NONE");
        }
        String defaultKeyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword", "");
        char[] passwd = defaultKeyStorePassword.isEmpty() ? null : defaultKeyStorePassword.toCharArray();
        try {
            KeyStore ks = OkHttpClientFactory.initKeyStore(logger, defaultKeyStore, defaultKeyStoreType, defaultKeyStoreProvider, passwd);
            logger.debug("init keymanager of type " + KeyManagerFactory.getDefaultAlgorithm());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            if (P11KEYSTORE.equals(defaultKeyStoreType)) {
                kmf.init(ks, null);
            } else {
                kmf.init(ks, passwd);
            }
            return kmf.getKeyManagers();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to initialize key manager", e);
        }
    }

    private static KeyStore initKeyStore(Logger logger, String defaultKeyStore, String defaultKeyStoreType, String defaultKeyStoreProvider, char[] passwd) throws KeyStoreException, NoSuchProviderException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore ks = null;
        if (!defaultKeyStoreType.isEmpty()) {
            logger.debug("init keystore");
            ks = defaultKeyStoreProvider.isEmpty() ? KeyStore.getInstance(defaultKeyStoreType) : KeyStore.getInstance(defaultKeyStoreType, defaultKeyStoreProvider);
            if (!defaultKeyStore.isEmpty() && !NONE.equals(defaultKeyStore)) {
                try (FileInputStream fs = new FileInputStream(defaultKeyStore);){
                    ks.load(fs, passwd);
                }
            } else {
                ks.load(null, passwd);
            }
        }
        return ks;
    }
}

