/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.xml.checks;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.rule.RuleKey;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.sonarsource.analyzer.commons.xml.XmlTextRange;
import org.w3c.dom.Node;

public abstract class SonarXmlCheck {
    private SensorContext context;
    private InputFile inputFile;
    private RuleKey ruleKey;

    public final void scanFile(SensorContext context, RuleKey ruleKey, XmlFile file) {
        this.context = context;
        this.inputFile = file.getInputFile();
        this.ruleKey = ruleKey;
        this.scanFile(file);
    }

    public final InputFile inputFile() {
        return this.inputFile;
    }

    public final RuleKey ruleKey() {
        return this.ruleKey;
    }

    public abstract void scanFile(XmlFile var1);

    public final void reportIssueOnFile(String message, List<Integer> secondaryLocationLines) {
        NewIssue issue = this.context.newIssue();
        NewIssueLocation location = issue.newLocation().on((InputComponent)this.inputFile).message(message);
        for (Integer line : secondaryLocationLines) {
            NewIssueLocation secondary = issue.newLocation().on((InputComponent)this.inputFile).at(this.inputFile.selectLine(line.intValue()));
            issue.addLocation(secondary);
        }
        issue.at(location).forRule(this.ruleKey).save();
    }

    public final void reportIssue(XmlTextRange textRange, String message, List<Secondary> secondaries) {
        NewIssue issue = this.context.newIssue();
        NewIssueLocation location = this.getLocation(textRange, issue).message(message);
        secondaries.forEach(secondary -> {
            NewIssueLocation secondaryLocation = this.getLocation(secondary.range, issue);
            if (secondary.message != null) {
                secondaryLocation.message(secondary.message);
            }
            issue.addLocation(secondaryLocation);
        });
        issue.at(location).forRule(this.ruleKey).save();
    }

    private NewIssueLocation getLocation(XmlTextRange textRange, NewIssue issue) {
        return issue.newLocation().on((InputComponent)this.inputFile).at(this.inputFile.newRange(textRange.getStartLine(), textRange.getStartColumn(), textRange.getEndLine(), textRange.getEndColumn()));
    }

    public final void reportIssue(Node node, String message) {
        XmlTextRange textRange = XmlFile.nodeLocation(node);
        this.reportIssue(textRange, message, Collections.emptyList());
    }

    public static class Secondary {
        final XmlTextRange range;
        @Nullable
        final String message;

        public Secondary(XmlTextRange range, @Nullable String message) {
            this.range = range;
            this.message = message;
        }

        public Secondary(Node node, @Nullable String message) {
            this.range = XmlFile.nodeLocation(node);
            this.message = message;
        }
    }
}

