/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.ast;

import java.util.Objects;

public class IndexRange {
    private final int beginningOffset;
    private final int endingOffset;

    public IndexRange(int beginningOffset, int endingOffset) {
        this.beginningOffset = beginningOffset;
        this.endingOffset = endingOffset;
    }

    public int getBeginningOffset() {
        return this.beginningOffset;
    }

    public int getEndingOffset() {
        return this.endingOffset;
    }

    public IndexRange merge(IndexRange other) {
        return this.extendTo(other.endingOffset);
    }

    public IndexRange extendTo(int newEnd) {
        return new IndexRange(this.beginningOffset, newEnd);
    }

    public boolean equals(Object other) {
        return other instanceof IndexRange && this.beginningOffset == ((IndexRange)other).beginningOffset && this.endingOffset == ((IndexRange)other).endingOffset;
    }

    public int hashCode() {
        return Objects.hash(this.beginningOffset, this.endingOffset);
    }

    public String toString() {
        return this.beginningOffset + "-" + this.endingOffset;
    }
}

