/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.surefire.data;

import java.text.ParseException;
import java.util.Locale;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.staxmate.in.ElementFilter;
import org.codehaus.staxmate.in.SMEvent;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.api.utils.ParsingUtils;
import org.sonar.plugins.surefire.data.UnitTestClassReport;
import org.sonar.plugins.surefire.data.UnitTestIndex;
import org.sonar.plugins.surefire.data.UnitTestResult;

public class SurefireStaxHandler {
    private final UnitTestIndex index;

    public SurefireStaxHandler(UnitTestIndex index) {
        this.index = index;
    }

    public void stream(SMHierarchicCursor rootCursor) throws XMLStreamException {
        SMInputCursor testSuite = rootCursor.constructDescendantCursor(new ElementFilter("testsuite"));
        SMEvent testSuiteEvent = testSuite.getNext();
        while (testSuiteEvent != null) {
            if (testSuiteEvent.compareTo(SMEvent.START_ELEMENT) == 0) {
                String testSuiteClassName = testSuite.getAttrValue("name");
                this.parseTestCase(testSuiteClassName, testSuite.childCursor(new ElementFilter("testcase")));
            }
            testSuiteEvent = testSuite.getNext();
        }
    }

    private void parseTestCase(String testSuiteClassName, SMInputCursor testCase) throws XMLStreamException {
        SMEvent event = testCase.getNext();
        while (event != null) {
            if (event.compareTo(SMEvent.START_ELEMENT) == 0) {
                String testClassName = SurefireStaxHandler.getClassname(testCase, testSuiteClassName);
                UnitTestClassReport classReport = this.index.index(testClassName);
                SurefireStaxHandler.parseTestCase(testCase, testSuiteClassName, classReport);
            }
            event = testCase.getNext();
        }
    }

    private static String getClassname(SMInputCursor testCaseCursor, String defaultClassname) throws XMLStreamException {
        int openParenthesisIndex;
        String testClassName = testCaseCursor.getAttrValue("classname");
        if (StringUtils.isNotBlank(testClassName) && testClassName.endsWith(")") && (openParenthesisIndex = testClassName.indexOf(40)) > 0) {
            testClassName = testClassName.substring(0, openParenthesisIndex);
        }
        return StringUtils.defaultIfBlank(testClassName, defaultClassname);
    }

    private static void parseTestCase(SMInputCursor testCaseCursor, String testSuiteClassName, UnitTestClassReport report) throws XMLStreamException {
        report.add(SurefireStaxHandler.parseTestResult(testCaseCursor, testSuiteClassName));
    }

    private static void setStackAndMessage(UnitTestResult result, SMInputCursor stackAndMessageCursor) throws XMLStreamException {
        result.setMessage(stackAndMessageCursor.getAttrValue("message"));
        String stack = stackAndMessageCursor.collectDescendantText();
        result.setStackTrace(stack);
    }

    private static UnitTestResult parseTestResult(SMInputCursor testCaseCursor, String testSuiteClassName) throws XMLStreamException {
        UnitTestResult detail = new UnitTestResult();
        String name = SurefireStaxHandler.getTestCaseName(testCaseCursor);
        detail.setName(name);
        detail.setTestSuiteClassName(testSuiteClassName);
        String status = "ok";
        String time = testCaseCursor.getAttrValue("time");
        Long duration = null;
        SMInputCursor childNode = testCaseCursor.descendantElementCursor();
        if (childNode.getNext() != null) {
            String elementName = childNode.getLocalName();
            if ("skipped".equals(elementName)) {
                status = "skipped";
                duration = 0L;
            } else if ("failure".equals(elementName)) {
                status = "failure";
                SurefireStaxHandler.setStackAndMessage(detail, childNode);
            } else if ("error".equals(elementName)) {
                status = "error";
                SurefireStaxHandler.setStackAndMessage(detail, childNode);
            }
        }
        while (childNode.getNext() != null) {
        }
        if (duration == null) {
            duration = SurefireStaxHandler.getTimeAttributeInMS(time);
        }
        detail.setDurationMilliseconds(duration);
        detail.setStatus(status);
        return detail;
    }

    private static long getTimeAttributeInMS(String value) throws XMLStreamException {
        try {
            Double time = ParsingUtils.parseNumber((String)value, (Locale)Locale.ENGLISH);
            return !Double.isNaN(time) ? (long)ParsingUtils.scaleValue((double)(time * 1000.0), (int)3) : 0L;
        }
        catch (ParseException e) {
            throw new XMLStreamException(e);
        }
    }

    private static String getTestCaseName(SMInputCursor testCaseCursor) throws XMLStreamException {
        String classname = testCaseCursor.getAttrValue("classname");
        String name = testCaseCursor.getAttrValue("name");
        if (StringUtils.contains((CharSequence)classname, "$")) {
            return StringUtils.substringAfter(classname, "$") + "/" + name;
        }
        return name;
    }
}

