/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.checks.CheckList;
import org.sonarsource.analyzer.commons.ProgressReport;
import org.sonarsource.analyzer.commons.xml.ParseException;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.sonarsource.analyzer.commons.xml.checks.SonarXmlCheck;

public class XmlFileSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(XmlFileSensor.class);
    private final Checks<SonarXmlCheck> checks;

    public XmlFileSensor(CheckFactory checkFactory) {
        this.checks = checkFactory.create("java").addAnnotatedChecks(CheckList.getXmlChecks());
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.name("JavaXmlSensor").onlyWhenConfiguration(configuration -> !this.checks.all().isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(SensorContext context) {
        FileSystem fs = context.fileSystem();
        FilePredicate xmlFilesPredicate = fs.predicates().matchesPathPattern("**/*.xml");
        ArrayList inputFiles = new ArrayList();
        fs.inputFiles(xmlFilesPredicate).forEach(inputFile1 -> {
            context.markForPublishing(inputFile1);
            inputFiles.add(inputFile1);
        });
        if (inputFiles.isEmpty()) {
            return;
        }
        ProgressReport progressReport = new ProgressReport("Report about progress of Java XML analyzer", TimeUnit.SECONDS.toMillis(10L));
        progressReport.start(inputFiles.stream().map(InputFile::toString).collect(Collectors.toList()));
        boolean successfullyCompleted = false;
        boolean cancelled = false;
        try {
            for (InputFile inputFile : inputFiles) {
                if (context.isCancelled()) {
                    cancelled = true;
                    break;
                }
                this.scanFile(context, inputFile);
                progressReport.nextFile();
            }
            successfullyCompleted = !cancelled;
        }
        finally {
            if (successfullyCompleted) {
                progressReport.stop();
            } else {
                progressReport.cancel();
            }
        }
    }

    private void scanFile(SensorContext context, InputFile inputFile) {
        XmlFile xmlFile;
        try {
            xmlFile = XmlFile.create(inputFile);
        }
        catch (IOException | ParseException e) {
            LOG.debug("Skipped '{}' due to parsing error", (Object)inputFile);
            return;
        }
        catch (Exception e) {
            LOG.warn(String.format("Unable to analyse file '%s'.", inputFile), (Throwable)e);
            return;
        }
        this.checks.all().forEach(check -> {
            RuleKey ruleKey = this.checks.ruleKey(check);
            this.scanFile(context, xmlFile, (SonarXmlCheck)check, ruleKey);
        });
    }

    @VisibleForTesting
    void scanFile(SensorContext context, XmlFile xmlFile, SonarXmlCheck check, RuleKey ruleKey) {
        try {
            check.scanFile(context, ruleKey, xmlFile);
        }
        catch (Exception e) {
            LOG.error(String.format("Failed to analyze '%s' with rule %s", xmlFile.getInputFile().toString(), ruleKey), (Throwable)e);
        }
    }
}

