/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java;

import org.sonar.api.Plugin;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.java.externalreport.CheckstyleSensor;
import org.sonar.java.externalreport.ExternalRulesDefinition;
import org.sonar.java.externalreport.PmdSensor;
import org.sonar.java.externalreport.SpotBugsSensor;

public final class ExternalReportExtensions {
    private static final String EXTERNAL_ANALYZERS_CATEGORY = "External Analyzers";
    private static final String JAVA_SUBCATEGORY = "Java";

    private ExternalReportExtensions() {
    }

    public static void define(Plugin.Context context) {
        context.addExtension(CheckstyleSensor.class);
        context.addExtension(PmdSensor.class);
        context.addExtension(SpotBugsSensor.class);
        context.addExtension((Object)new ExternalRulesDefinition(CheckstyleSensor.RULE_LOADER, "checkstyle"));
        context.addExtension((Object)PropertyDefinition.builder((String)"sonar.java.checkstyle.reportPaths").name("Checkstyle Report Files").description("Paths (absolute or relative) to xml files with Checkstyle issues.").category(EXTERNAL_ANALYZERS_CATEGORY).subCategory(JAVA_SUBCATEGORY).onQualifiers("TRK", new String[0]).multiValues(true).build());
        context.addExtension((Object)new ExternalRulesDefinition(PmdSensor.RULE_LOADER, "pmd"));
        context.addExtension((Object)PropertyDefinition.builder((String)"sonar.java.pmd.reportPaths").name("PMD Report Files").description("Paths (absolute or relative) to xml files with PMD issues.").category(EXTERNAL_ANALYZERS_CATEGORY).subCategory(JAVA_SUBCATEGORY).onQualifiers("TRK", new String[0]).multiValues(true).build());
        context.addExtension((Object)new ExternalRulesDefinition(SpotBugsSensor.RULE_LOADER, "spotbugs"));
        context.addExtension((Object)new ExternalRulesDefinition(SpotBugsSensor.FINDSECBUGS_LOADER, "findsecbugs"));
        context.addExtension((Object)new ExternalRulesDefinition(SpotBugsSensor.FBCONTRIB_LOADER, "fbcontrib"));
        context.addExtension((Object)PropertyDefinition.builder((String)"sonar.java.spotbugs.reportPaths").name("SpotBugs Report Files").description("Paths (absolute or relative) to xml files with SpotBugs issues.").category(EXTERNAL_ANALYZERS_CATEGORY).subCategory(JAVA_SUBCATEGORY).onQualifiers("TRK", new String[0]).multiValues(true).build());
    }
}

