/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.xproc;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.model.JUtils;
import org.sonar.java.se.SymbolicExecutionVisitor;
import org.sonar.java.se.xproc.MethodBehavior;
import org.sonar.java.se.xproc.MethodBehaviorJsonAdapter;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.MethodTree;

public class BehaviorCache {
    private static final Logger LOG = Loggers.get(BehaviorCache.class);
    private SymbolicExecutionVisitor sev;
    @VisibleForTesting
    public final Map<String, MethodBehavior> behaviors = new LinkedHashMap<String, MethodBehavior>();
    private Map<String, MethodBehavior> hardcodedBehaviors = null;

    public void setFileContext(@Nullable SymbolicExecutionVisitor sev) {
        this.sev = sev;
    }

    public void cleanup() {
        this.behaviors.clear();
    }

    @VisibleForTesting
    Map<String, MethodBehavior> hardcodedBehaviors() {
        if (this.hardcodedBehaviors == null) {
            this.hardcodedBehaviors = HardcodedMethodBehaviors.load();
            LOG.debug(String.format("[SE] Loaded %d hardcoded method behaviors.", this.hardcodedBehaviors.size()));
        }
        return this.hardcodedBehaviors;
    }

    public MethodBehavior methodBehaviorForSymbol(Symbol.MethodSymbol symbol) {
        String signature = symbol.signature();
        boolean varArgs = JUtils.isVarArgsMethod(symbol);
        return this.behaviors.computeIfAbsent(signature, k -> new MethodBehavior(signature, varArgs));
    }

    @CheckForNull
    public MethodBehavior get(Symbol.MethodSymbol symbol) {
        return this.get(symbol.signature(), symbol);
    }

    @CheckForNull
    public MethodBehavior get(String signature) {
        return this.get(signature, null);
    }

    @CheckForNull
    private MethodBehavior get(String signature, @Nullable Symbol.MethodSymbol symbol) {
        MethodBehavior mb = this.behaviors.get(signature);
        if (mb != null) {
            return mb;
        }
        if (symbol != null) {
            MethodTree declaration = symbol.declaration();
            if (SymbolicExecutionVisitor.methodCanNotBeOverriden(symbol) && declaration != null) {
                this.sev.execute(declaration);
                return this.behaviors.get(signature);
            }
        }
        return this.hardcodedBehaviors().get(signature);
    }

    @CheckForNull
    public MethodBehavior peek(String signature) {
        MethodBehavior mb = this.behaviors.get(signature);
        if (mb != null) {
            return mb;
        }
        return this.hardcodedBehaviors().get(signature);
    }

    static class HardcodedMethodBehaviors {
        private static final String UNABLE_LOAD_MSG = "[SE] Unable to load hardcoded method behaviors. Defaulting to no hardcoded method behaviors.";
        private static final String[] BEHAVIORS_RESOURCES = new String[]{"java.lang.json", "java.util.json", "com.google.common.base.json", "org.apache.commons.collections.json", "org.apache.commons.lang.json", "org.apache.commons.lang3.json", "org.apache.logging.log4j.core.util.json", "org.eclipse.core.runtime.json", "org.springframework.util.json"};
        private static final Type LIST_OF_METHOD_BEHAVIORS_TYPE = new TypeToken<List<MethodBehavior>>(){}.getType();
        private final Map<String, MethodBehavior> storedHardcodedMethodBehaviors = HardcodedMethodBehaviors.loadHardcodedBehaviors();
        private static HardcodedMethodBehaviors uniqueInstance = null;

        private HardcodedMethodBehaviors() {
        }

        private static HardcodedMethodBehaviors uniqueInstance() {
            if (uniqueInstance == null) {
                uniqueInstance = new HardcodedMethodBehaviors();
            }
            return uniqueInstance;
        }

        public static Map<String, MethodBehavior> load() {
            return HardcodedMethodBehaviors.uniqueInstance().storedHardcodedMethodBehaviors;
        }

        private static Map<String, MethodBehavior> loadHardcodedBehaviors() {
            return HardcodedMethodBehaviors.loadHardcodedBehaviors(() -> Arrays.stream(BEHAVIORS_RESOURCES).map(BehaviorCache.class::getResourceAsStream).collect(Collectors.toList()));
        }

        @VisibleForTesting
        static Map<String, MethodBehavior> loadHardcodedBehaviors(Supplier<List<InputStream>> methodBehaviorStreamsSupplier) {
            LinkedHashMap result = new LinkedHashMap();
            Gson gson = MethodBehaviorJsonAdapter.gson();
            for (InputStream serializedStream : methodBehaviorStreamsSupplier.get()) {
                if (serializedStream == null) {
                    LOG.debug(UNABLE_LOAD_MSG);
                    return Collections.emptyMap();
                }
                try (InputStreamReader reader = new InputStreamReader(serializedStream, StandardCharsets.UTF_8);){
                    List deserialized = (List)gson.fromJson((Reader)reader, LIST_OF_METHOD_BEHAVIORS_TYPE);
                    deserialized.forEach(methodBehavior -> result.put(methodBehavior.signature(), methodBehavior));
                }
                catch (Exception e) {
                    LOG.error(UNABLE_LOAD_MSG, (Throwable)e);
                    return Collections.emptyMap();
                }
            }
            return Collections.unmodifiableMap(result);
        }
    }
}

