/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.collections.ListUtils;
import org.sonar.java.collections.SetUtils;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.ExplodedGraph;
import org.sonar.java.se.Flow;
import org.sonar.java.se.FlowComputation;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodReferenceTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3959")
public class StreamConsumedCheck
extends SECheck {
    private static final Set<String> STREAM_TYPES = SetUtils.immutableSetOf("java.util.stream.Stream", "java.util.stream.IntStream", "java.util.stream.LongStream", "java.util.stream.DoubleStream");
    private static final MethodMatchers TERMINAL_OPERATIONS = MethodMatchers.or(MethodMatchers.create().ofTypes(STREAM_TYPES.toArray(new String[0])).names("forEach", "forEachOrdered", "toArray", "collect", "reduce", "findAny", "findFirst", "count", "min", "max", "anyMatch", "allMatch", "noneMatch", "average", "summaryStatistics", "sum").withAnyParameters().build(), MethodMatchers.create().ofSubTypes("java.util.stream.BaseStream").names("iterator", "spliterator").addWithoutParametersMatcher().build());
    private static final MethodMatchers.NameBuilder JAVA_UTIL_STREAM_BASESTREAM = MethodMatchers.create().ofSubTypes("java.util.stream.BaseStream");
    private static final MethodMatchers BASE_STREAM_INTERMEDIATE_OPERATIONS = MethodMatchers.or(JAVA_UTIL_STREAM_BASESTREAM.names("sequential", "parallel", "unordered").addWithoutParametersMatcher().build(), JAVA_UTIL_STREAM_BASESTREAM.names("onClose").withAnyParameters().build());

    @Override
    public ProgramState checkPreStatement(CheckerContext context, Tree syntaxNode) {
        if (syntaxNode.is(Tree.Kind.METHOD_REFERENCE)) {
            return this.handleMethodReference(context, (MethodReferenceTree)syntaxNode);
        }
        if (syntaxNode.is(Tree.Kind.METHOD_INVOCATION)) {
            return this.handleMethodInvocation(context, (MethodInvocationTree)syntaxNode);
        }
        if (syntaxNode.is(Tree.Kind.NEW_CLASS)) {
            return StreamConsumedCheck.removeConstraintOnArgs(context.getState(), ((NewClassTree)syntaxNode).arguments().size());
        }
        ProgramState state = context.getState();
        if (state.peekValue() instanceof SymbolicValue.ExceptionalSymbolicValue) {
            state = StreamConsumedCheck.removeNotConsumedConstraints(context.getState());
        }
        return state;
    }

    private static ProgramState removeNotConsumedConstraints(ProgramState programState) {
        ProgramState intermediateState = programState;
        for (SymbolicValue notConsumed : intermediateState.getValuesWithConstraints(StreamPipelineConstraint.NOT_CONSUMED)) {
            intermediateState = intermediateState.removeConstraintsOnDomain(notConsumed, StreamPipelineConstraint.class);
        }
        return intermediateState;
    }

    private ProgramState handleMethodInvocation(CheckerContext context, MethodInvocationTree mit) {
        ProgramState programState = context.getState();
        programState = StreamConsumedCheck.removeConstraintOnArgs(programState, mit.arguments().size());
        SymbolicValue invocationTarget = StreamConsumedCheck.invocationTarget(programState, mit);
        if ((StreamConsumedCheck.isIntermediateOperation(mit) || StreamConsumedCheck.isTerminalOperation(mit)) && StreamConsumedCheck.isPipelineConsumed(programState, invocationTarget)) {
            this.reportIssue(mit, "Refactor this code so that this consumed stream pipeline is not reused.", StreamConsumedCheck.flow(invocationTarget, context.getNode()));
            return null;
        }
        if (StreamConsumedCheck.isIntermediateOperation(mit)) {
            context.getConstraintManager().setValueFactory(() -> invocationTarget);
            return ListUtils.getOnlyElement(invocationTarget.setConstraint(programState, StreamPipelineConstraint.NOT_CONSUMED));
        }
        if (StreamConsumedCheck.isTerminalOperation(mit)) {
            return ListUtils.getOnlyElement(invocationTarget.setConstraint(programState, StreamPipelineConstraint.CONSUMED));
        }
        if (mit.symbol().isUnknown()) {
            programState = programState.removeConstraintsOnDomain(invocationTarget, StreamPipelineConstraint.class);
        }
        return programState;
    }

    private ProgramState handleMethodReference(CheckerContext context, MethodReferenceTree mrt) {
        ProgramState programState = context.getState();
        if (TERMINAL_OPERATIONS.matches(mrt.method().symbol())) {
            Tree expression = mrt.expression();
            if (expression.is(Tree.Kind.IDENTIFIER)) {
                SymbolicValue ownerSV = programState.getValue(((IdentifierTree)expression).symbol());
                if (ownerSV == null) {
                    return programState;
                }
                if (StreamConsumedCheck.isPipelineConsumed(programState, ownerSV)) {
                    this.reportIssue(mrt, "Refactor this code so that this consumed stream pipeline is not reused.", StreamConsumedCheck.flow(ownerSV, context.getNode()));
                    return null;
                }
                return ListUtils.getOnlyElement(ownerSV.setConstraint(programState, StreamPipelineConstraint.CONSUMED));
            }
        }
        return programState;
    }

    private static ProgramState removeConstraintOnArgs(ProgramState programState, int argumentCount) {
        ProgramState state = programState;
        for (SymbolicValue arg : programState.peekValues(argumentCount)) {
            state = state.removeConstraintsOnDomain(arg, StreamPipelineConstraint.class);
        }
        return state;
    }

    private static SymbolicValue invocationTarget(ProgramState programState, MethodInvocationTree mit) {
        return programState.peekValue(mit.arguments().size());
    }

    private static boolean isIntermediateOperation(MethodInvocationTree mit) {
        if (BASE_STREAM_INTERMEDIATE_OPERATIONS.matches(mit)) {
            return true;
        }
        Symbol method = mit.symbol();
        return method.isMethodSymbol() && !method.isStatic() && STREAM_TYPES.contains(method.owner().type().fullyQualifiedName()) && STREAM_TYPES.contains(((Symbol.MethodSymbol)method).returnType().type().fullyQualifiedName());
    }

    private static boolean isPipelineConsumed(ProgramState programState, SymbolicValue symbolicValue) {
        StreamPipelineConstraint constraint = programState.getConstraint(symbolicValue, StreamPipelineConstraint.class);
        return constraint == StreamPipelineConstraint.CONSUMED;
    }

    private static boolean isTerminalOperation(MethodInvocationTree methodInvocationTree) {
        return TERMINAL_OPERATIONS.matches(methodInvocationTree);
    }

    private static Set<Flow> flow(SymbolicValue invocationTarget, ExplodedGraph.Node node) {
        Set<Flow> flows = FlowComputation.flow(node, Collections.singleton(invocationTarget), StreamPipelineConstraint.CONSUMED::equals, c -> false, Collections.singletonList(StreamPipelineConstraint.class), Collections.emptySet(), 20);
        return flows.stream().map(StreamConsumedCheck::copyFlowWithExplicitMessage).collect(Collectors.toSet());
    }

    private static Flow copyFlowWithExplicitMessage(Flow flow) {
        Flow.Builder flowBuilder = Flow.builder();
        flow.stream().map(l -> new JavaFileScannerContext.Location("Pipeline is consumed here.", StreamConsumedCheck.flowTree(l.syntaxNode))).forEach(flowBuilder::add);
        return flowBuilder.build();
    }

    private static Tree flowTree(Tree tree) {
        if (tree.is(Tree.Kind.METHOD_INVOCATION)) {
            ExpressionTree methodSelect = ((MethodInvocationTree)tree).methodSelect();
            if (methodSelect.is(Tree.Kind.MEMBER_SELECT)) {
                return ((MemberSelectExpressionTree)methodSelect).identifier();
            }
        }
        return tree;
    }

    @Override
    public ProgramState checkPostStatement(CheckerContext context, Tree syntaxNode) {
        ProgramState state = context.getState();
        if (StreamConsumedCheck.isReturningPipeline(syntaxNode) || StreamConsumedCheck.nonLocalAssignment(syntaxNode)) {
            return state.removeConstraintsOnDomain(state.peekValue(), StreamPipelineConstraint.class);
        }
        return state;
    }

    private static boolean nonLocalAssignment(Tree syntaxNode) {
        if (syntaxNode.is(Tree.Kind.ASSIGNMENT)) {
            ExpressionTree variable = ((AssignmentExpressionTree)syntaxNode).variable();
            return !variable.is(Tree.Kind.IDENTIFIER) || ((IdentifierTree)variable).symbol().owner().isTypeSymbol();
        }
        return false;
    }

    private static boolean isReturningPipeline(Tree syntaxNode) {
        return syntaxNode.is(Tree.Kind.RETURN_STATEMENT) && ((ReturnStatementTree)syntaxNode).expression() != null;
    }

    public static enum StreamPipelineConstraint implements Constraint
    {
        CONSUMED,
        NOT_CONSUMED;

    }
}

