/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.sonar.java.model.JSema;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;

final class JType
implements Type,
Type.ArrayType {
    final JSema sema;
    final ITypeBinding typeBinding;
    private final String fullyQualifiedName;
    private List<Type> typeArguments;

    JType(JSema sema, ITypeBinding typeBinding) {
        this.sema = Objects.requireNonNull(sema);
        this.typeBinding = Objects.requireNonNull(typeBinding);
        this.fullyQualifiedName = JType.fullyQualifiedName(typeBinding);
    }

    @Override
    public boolean is(String fullyQualifiedName) {
        return fullyQualifiedName.equals(this.fullyQualifiedName());
    }

    @Override
    public boolean isSubtypeOf(String fullyQualifiedName) {
        return this.isSubtypeOf(this.sema.getClassType(fullyQualifiedName));
    }

    @Override
    public boolean isSubtypeOf(Type superType) {
        return !superType.isUnknown() && JType.isSubtype(this.typeBinding, ((JType)superType).typeBinding);
    }

    private static boolean isSubtype(ITypeBinding left, ITypeBinding right) {
        if (left.isRecovered()) {
            return false;
        }
        if (left.isNullType()) {
            return !right.isPrimitive();
        }
        return left.isSubTypeCompatible(right);
    }

    @Override
    public boolean isArray() {
        return this.typeBinding.isArray();
    }

    @Override
    public boolean isClass() {
        return this.typeBinding.isClass() || this.typeBinding.isInterface() || this.typeBinding.isEnum();
    }

    @Override
    public boolean isVoid() {
        return "void".equals(this.fullyQualifiedName());
    }

    @Override
    public boolean isPrimitive() {
        return this.typeBinding.isPrimitive() && !this.isVoid();
    }

    @Override
    public boolean isPrimitive(Type.Primitives primitive) {
        return primitive.name().toLowerCase().equals(this.fullyQualifiedName());
    }

    @Override
    public boolean isUnknown() {
        return this.typeBinding.isRecovered();
    }

    @Override
    public boolean isNumerical() {
        switch (this.fullyQualifiedName()) {
            case "byte": 
            case "char": 
            case "short": 
            case "int": 
            case "long": 
            case "float": 
            case "double": {
                return true;
            }
        }
        return false;
    }

    @Override
    public String fullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    private static String fullyQualifiedName(ITypeBinding typeBinding) {
        if (typeBinding.isNullType()) {
            return "<nulltype>";
        }
        if (typeBinding.isPrimitive()) {
            return typeBinding.getName();
        }
        if (typeBinding.isArray()) {
            return JType.fullyQualifiedName(typeBinding.getComponentType()) + "[]";
        }
        if (typeBinding.isCapture()) {
            return "!capture!";
        }
        if (typeBinding.isTypeVariable()) {
            return typeBinding.getName();
        }
        String binaryName = typeBinding.getBinaryName();
        if (binaryName == null) {
            return typeBinding.getKey();
        }
        return binaryName;
    }

    @Override
    public String name() {
        if (this.typeBinding.isNullType()) {
            return "<nulltype>";
        }
        if (this.typeBinding.isParameterizedType()) {
            return this.typeBinding.getErasure().getName();
        }
        return this.typeBinding.getName();
    }

    public String toString() {
        return this.name();
    }

    @Override
    public Symbol.TypeSymbol symbol() {
        return this.sema.typeSymbol(this.typeBinding);
    }

    @Override
    public Type erasure() {
        return this.sema.type(this.typeBinding.getErasure());
    }

    @Override
    public Type elementType() {
        return this.sema.type(this.typeBinding.getComponentType());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof JType) {
            JType other = (JType)obj;
            return JType.areEqual(this.typeBinding, other.typeBinding);
        }
        return false;
    }

    public int hashCode() {
        return this.fullyQualifiedName().hashCode();
    }

    static boolean areEqual(@Nullable ITypeBinding binding1, @Nullable ITypeBinding binding2) {
        if (binding1 == null || binding2 == null) {
            return binding1 == binding2;
        }
        if (binding1.isWildcardType()) {
            return binding2.isWildcardType() && binding1.isUpperbound() == binding2.isUpperbound() && JType.areEqual(binding1.getBound(), binding2.getBound());
        }
        return binding1.getTypeDeclaration().equals(binding2.getTypeDeclaration()) && JType.isParameterizedOrGeneric(binding1) == JType.isParameterizedOrGeneric(binding2) && binding1.isRawType() == binding2.isRawType() && Arrays.equals(binding1.getTypeParameters(), binding2.getTypeParameters()) && Arrays.equals(binding1.getTypeArguments(), binding2.getTypeArguments());
    }

    static ITypeBinding normalize(ITypeBinding typeBinding) {
        ITypeBinding typeDeclaration = typeBinding.getTypeDeclaration();
        if (typeBinding.isLocal()) {
            return typeDeclaration;
        }
        return typeBinding.isParameterizedType() && Arrays.equals(typeDeclaration.getTypeParameters(), typeBinding.getTypeArguments()) ? typeDeclaration : typeBinding;
    }

    private static boolean isParameterizedOrGeneric(ITypeBinding typeBinding) {
        return typeBinding.isParameterizedType() || typeBinding.isGenericType();
    }

    @Override
    public boolean isParameterized() {
        return this.typeBinding.isParameterizedType() && !this.typeArguments().isEmpty();
    }

    @Override
    public List<Type> typeArguments() {
        if (this.typeArguments == null) {
            this.typeArguments = this.sema.types(this.typeBinding.getTypeArguments());
        }
        return this.typeArguments;
    }
}

