/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.matcher;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.java.collections.SetUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodReferenceTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

public class MethodMatchersBuilder
implements MethodMatchers.TypeBuilder,
MethodMatchers.NameBuilder,
MethodMatchers.ParametersBuilder,
MethodMatchers {
    @Nullable
    private final Predicate<Type> typePredicate;
    @Nullable
    private final Predicate<String> namePredicate;
    @Nullable
    private final Predicate<List<Type>> parametersPredicate;

    public MethodMatchersBuilder() {
        this.typePredicate = null;
        this.namePredicate = null;
        this.parametersPredicate = null;
    }

    private MethodMatchersBuilder(@Nullable Predicate<Type> typePredicate, @Nullable Predicate<String> namePredicate, @Nullable Predicate<List<Type>> parametersPredicate) {
        this.typePredicate = typePredicate;
        this.namePredicate = namePredicate;
        this.parametersPredicate = parametersPredicate;
    }

    private static <T> Predicate<T> substituteAny(Predicate<T> predicate, String ... elements) {
        if (SetUtils.immutableSetOf(elements).contains("*")) {
            if (elements.length > 1) {
                throw new IllegalStateException("Incompatible MethodMatchers.ANY with other predicates.");
            }
            return e -> true;
        }
        return predicate;
    }

    private static <T> Predicate<T> substituteAnyAndCreateEfficientPredicate(String[] elements, Function<String, Predicate<T>> singleElementPredicate, Function<List<String>, Predicate<T>> multiElementsPredicate) {
        if (elements.length == 0) {
            throw new IllegalStateException("Method arguments can not be empty, otherwise the predicate would be always false.");
        }
        if (elements.length == 1) {
            String singleElement = elements[0];
            return MethodMatchersBuilder.substituteAny(singleElementPredicate.apply(singleElement), elements);
        }
        List<String> multiElements = Arrays.asList(elements);
        return MethodMatchersBuilder.substituteAny(multiElementsPredicate.apply(multiElements), elements);
    }

    @Override
    public MethodMatchers.NameBuilder ofSubTypes(String ... fullyQualifiedTypeNames) {
        return this.ofType(MethodMatchersBuilder.substituteAnyAndCreateEfficientPredicate(fullyQualifiedTypeNames, name -> type -> type.isSubtypeOf((String)name), names -> type -> names.stream().anyMatch(type::isSubtypeOf)));
    }

    @Override
    public MethodMatchers.NameBuilder ofAnyType() {
        return this.ofTypes("*");
    }

    @Override
    public MethodMatchers.NameBuilder ofTypes(String ... fullyQualifiedTypeNames) {
        return this.ofType(MethodMatchersBuilder.substituteAnyAndCreateEfficientPredicate(fullyQualifiedTypeNames, name -> type -> type.is((String)name), names -> type -> names.stream().anyMatch(type::is)));
    }

    @Override
    public MethodMatchers.NameBuilder ofType(Predicate<Type> typePredicate) {
        return new MethodMatchersBuilder(MethodMatchersBuilder.or(this.typePredicate, typePredicate), this.namePredicate, this.parametersPredicate);
    }

    @Override
    public MethodMatchers.ParametersBuilder names(String ... names) {
        return this.name(MethodMatchersBuilder.substituteAnyAndCreateEfficientPredicate(names, name -> name::equals, nameList -> nameList::contains));
    }

    @Override
    public MethodMatchers.ParametersBuilder anyName() {
        return this.names("*");
    }

    @Override
    public MethodMatchers.ParametersBuilder constructor() {
        return this.names("<init>");
    }

    @Override
    public MethodMatchers.ParametersBuilder name(Predicate<String> namePredicate) {
        return new MethodMatchersBuilder(this.typePredicate, MethodMatchersBuilder.or(this.namePredicate, namePredicate), this.parametersPredicate);
    }

    @Override
    public MethodMatchers.ParametersBuilder addParametersMatcher(String ... parametersType) {
        return this.addParametersMatcher(Arrays.stream(parametersType).map(parameterType -> MethodMatchersBuilder.substituteAny(type -> type.is((String)parameterType), parameterType)).collect(Collectors.toList()));
    }

    private MethodMatchers.ParametersBuilder addParametersMatcher(List<Predicate<Type>> parametersType) {
        return this.addParametersMatcher((List<Type> actualTypes) -> MethodMatchersBuilder.exactMatchesParameters(parametersType, actualTypes));
    }

    @Override
    public MethodMatchers.ParametersBuilder addWithoutParametersMatcher() {
        return this.addParametersMatcher(Collections.emptyList());
    }

    @Override
    public MethodMatchers.ParametersBuilder withAnyParameters() {
        if (this.parametersPredicate != null) {
            throw new IllegalStateException("Incompatible 'any parameters' constraint added to existing parameters constraint.");
        }
        return this.addParametersMatcher((List<Type> actualParameters) -> true);
    }

    @Override
    public MethodMatchers.ParametersBuilder addParametersMatcher(Predicate<List<Type>> parametersPredicate) {
        return new MethodMatchersBuilder(this.typePredicate, this.namePredicate, MethodMatchersBuilder.or(this.parametersPredicate, parametersPredicate));
    }

    private static boolean exactMatchesParameters(List<Predicate<Type>> expectedTypes, List<Type> actualTypes) {
        return actualTypes.size() == expectedTypes.size() && MethodMatchersBuilder.matchesParameters(expectedTypes, actualTypes);
    }

    private static boolean matchesParameters(List<Predicate<Type>> expectedTypes, List<Type> actualTypes) {
        for (int i = 0; i < expectedTypes.size(); ++i) {
            if (expectedTypes.get(i).test(actualTypes.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matches(NewClassTree newClassTree) {
        return this.matches(newClassTree.constructorSymbol(), null);
    }

    @Override
    public boolean matches(MethodInvocationTree mit) {
        IdentifierTree id = MethodMatchersBuilder.getIdentifier(mit);
        return this.matches(id.symbol(), MethodMatchersBuilder.getCallSiteType(mit));
    }

    @Override
    public boolean matches(MethodTree methodTree) {
        Symbol.MethodSymbol symbol = methodTree.symbol();
        Symbol.TypeSymbol enclosingClass = symbol.enclosingClass();
        return enclosingClass != null && this.matches(symbol, enclosingClass.type());
    }

    @Override
    public boolean matches(MethodReferenceTree methodReferenceTree) {
        return this.matches(methodReferenceTree.method().symbol(), MethodMatchersBuilder.getCallSiteType(methodReferenceTree));
    }

    @Override
    public boolean matches(Symbol symbol) {
        return this.matches(symbol, null);
    }

    @Override
    public MethodMatchers build() {
        if (this.typePredicate == null || this.namePredicate == null || this.parametersPredicate == null) {
            throw new IllegalStateException("MethodMatchers need to be fully initialized.");
        }
        return this;
    }

    private boolean matches(Symbol symbol, @Nullable Type callSiteType) {
        return symbol.isMethodSymbol() && this.isSearchedMethod((Symbol.MethodSymbol)symbol, callSiteType);
    }

    @CheckForNull
    private static Type getCallSiteType(MethodReferenceTree referenceTree) {
        Tree expression = referenceTree.expression();
        if (expression instanceof ExpressionTree) {
            return ((ExpressionTree)expression).symbolType();
        }
        return null;
    }

    @CheckForNull
    private static Type getCallSiteType(MethodInvocationTree mit) {
        ExpressionTree methodSelect = mit.methodSelect();
        if (methodSelect.is(Tree.Kind.IDENTIFIER)) {
            Symbol.TypeSymbol enclosingClassSymbol = ((IdentifierTree)methodSelect).symbol().enclosingClass();
            return enclosingClassSymbol != null ? enclosingClassSymbol.type() : null;
        }
        return ((MemberSelectExpressionTree)methodSelect).expression().symbolType();
    }

    private boolean isSearchedMethod(Symbol.MethodSymbol symbol, @Nullable Type callSiteType) {
        Symbol owner;
        Type type = callSiteType;
        if (type == null && (owner = symbol.owner()) != null) {
            type = owner.type();
        }
        return type != null && this.namePredicate.test(symbol.name()) && this.parametersPredicate.test(symbol.parameterTypes()) && this.typePredicate.test(type);
    }

    private static IdentifierTree getIdentifier(MethodInvocationTree mit) {
        if (mit.methodSelect().is(Tree.Kind.IDENTIFIER)) {
            return (IdentifierTree)mit.methodSelect();
        }
        return ((MemberSelectExpressionTree)mit.methodSelect()).identifier();
    }

    private static <T> Predicate<T> or(@Nullable Predicate<T> accumulator, Predicate<T> next) {
        return accumulator != null ? accumulator.or(next) : next;
    }
}

