/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.xml.struts;

import java.util.List;
import java.util.stream.Collectors;
import javax.xml.xpath.XPathExpression;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.sonarsource.analyzer.commons.xml.checks.SimpleXPathBasedCheck;
import org.sonarsource.analyzer.commons.xml.checks.SonarXmlCheck;
import org.w3c.dom.Node;

@Rule(key="S3373")
public class ActionNumberCheck
extends SimpleXPathBasedCheck {
    private static final int DEFAULT_MAXIMUM_NUMBER_FORWARDS = 4;
    @RuleProperty(key="threshold", description="Maximum allowed number of ``<forward/>`` mappings in an ``<action>``", defaultValue="4")
    public int maximumForwards = 4;
    private XPathExpression actionsExpression = this.getXPathExpression("struts-config/action-mappings/action");
    private XPathExpression forwardsFromActionExpression = this.getXPathExpression("forward");

    @Override
    public void scanFile(XmlFile xmlFile) {
        this.evaluateAsList(this.actionsExpression, xmlFile.getNamespaceUnawareDocument()).forEach(this::checkAction);
    }

    private void checkAction(Node node) {
        List<SonarXmlCheck.Secondary> secondaries = this.evaluateAsList(this.forwardsFromActionExpression, node).stream().skip(this.maximumForwards).map(forward -> new SonarXmlCheck.Secondary((Node)forward, "Move this forward to another action.")).collect(Collectors.toList());
        if (!secondaries.isEmpty()) {
            int numberForward = this.maximumForwards + secondaries.size();
            String message = "Reduce the number of forwards in this action from " + numberForward + " to at most " + this.maximumForwards + ".";
            this.reportIssue(XmlFile.nodeLocation(node), message, secondaries);
        }
    }
}

