/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.unused;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2677")
public class UnusedReturnedDataCheck
extends IssuableSubscriptionVisitor {
    private static final List<MethodMatchers> CHECKED_METHODS = Arrays.asList(MethodMatchers.create().ofSubTypes("java.io.BufferedReader").names("readLine").addWithoutParametersMatcher().build(), MethodMatchers.create().ofSubTypes("java.io.Reader").names("read").addWithoutParametersMatcher().build());

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.EXPRESSION_STATEMENT, Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO);
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(Tree.Kind.EXPRESSION_STATEMENT)) {
            CHECKED_METHODS.stream().map(matcher -> UnusedReturnedDataCheck.isTreeMethodInvocation(((ExpressionStatementTree)tree).expression(), matcher)).filter(Objects::nonNull).forEach(mit -> this.raiseIssue(ExpressionUtils.methodName(mit)));
        } else {
            BinaryExpressionTree expressionTree = (BinaryExpressionTree)tree;
            ExpressionTree leftOperand = expressionTree.leftOperand();
            ExpressionTree rightOperand = expressionTree.rightOperand();
            for (MethodMatchers matcher2 : CHECKED_METHODS) {
                MethodInvocationTree rightMit;
                MethodInvocationTree leftMit = UnusedReturnedDataCheck.isTreeMethodInvocation(leftOperand, matcher2);
                if (leftMit != null && UnusedReturnedDataCheck.isTreeLiteralNull(rightOperand)) {
                    this.raiseIssue(ExpressionUtils.methodName(leftMit));
                }
                if ((rightMit = UnusedReturnedDataCheck.isTreeMethodInvocation(rightOperand, matcher2)) == null || !UnusedReturnedDataCheck.isTreeLiteralNull(leftOperand)) continue;
                this.raiseIssue(ExpressionUtils.methodName(rightMit));
            }
        }
    }

    @CheckForNull
    private static MethodInvocationTree isTreeMethodInvocation(ExpressionTree tree, MethodMatchers matcher) {
        MethodInvocationTree methodInvocation;
        ExpressionTree expression = ExpressionUtils.skipParentheses(tree);
        if (expression.is(Tree.Kind.METHOD_INVOCATION) && matcher.matches(methodInvocation = (MethodInvocationTree)expression)) {
            return methodInvocation;
        }
        return null;
    }

    private static boolean isTreeLiteralNull(ExpressionTree tree) {
        return ExpressionUtils.skipParentheses(tree).is(Tree.Kind.NULL_LITERAL);
    }

    private void raiseIssue(IdentifierTree identifierTree) {
        this.reportIssue(identifierTree, String.format("Use or store the value returned from \"%s\" instead of throwing it away.", identifierTree.identifierToken().text()));
    }
}

