/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.synchronization;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.serialization.SerializableContract;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.SynchronizedStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3042")
public class WriteObjectTheOnlySynchronizedMethodCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    @Override
    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        Symbol.TypeSymbol enclosingClass = methodTree.symbol().enclosingClass();
        String className = enclosingClass.type().fullyQualifiedName();
        MethodMatchers writeObjectMatcher = SerializableContract.writeObjectMatcher(className);
        if (writeObjectMatcher.matches(methodTree) && ModifiersUtils.hasModifier(methodTree.modifiers(), Modifier.SYNCHRONIZED)) {
            SynchronizationVisitor visitor = new SynchronizationVisitor(methodTree);
            enclosingClass.declaration().accept(visitor);
            if (!visitor.moreThanSingleLock) {
                this.reportIssue(ModifiersUtils.getModifier(methodTree.modifiers(), Modifier.SYNCHRONIZED), "Remove this \"synchronized\" keyword.");
            }
        }
    }

    private static class SynchronizationVisitor
    extends BaseTreeVisitor {
        private final MethodTree writeObjectMethodTree;
        private boolean moreThanSingleLock;

        public SynchronizationVisitor(MethodTree writeObjectMethodTree) {
            this.writeObjectMethodTree = writeObjectMethodTree;
        }

        @Override
        public void visitSynchronizedStatement(SynchronizedStatementTree tree) {
            this.moreThanSingleLock = true;
        }

        @Override
        public void visitMethod(MethodTree tree) {
            if (tree.equals(this.writeObjectMethodTree) || this.moreThanSingleLock) {
                return;
            }
            if (ModifiersUtils.hasModifier(tree.modifiers(), Modifier.SYNCHRONIZED)) {
                this.moreThanSingleLock = true;
                return;
            }
            super.visitMethod(tree);
        }
    }
}

