/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5301")
public class XxeActiveMQCheck
extends AbstractMethodDetection {
    private static final String CONSTRUCTOR = "<init>";
    private static final String MQ_CONNECTION_FACTORY_CLASS_NAME = "org.apache.activemq.ActiveMQConnectionFactory";

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes(MQ_CONNECTION_FACTORY_CLASS_NAME).names(CONSTRUCTOR).withAnyParameters().build();
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        MethodTree enclosingMethod = ExpressionUtils.getEnclosingMethod(newClassTree);
        if (enclosingMethod == null) {
            return;
        }
        Optional<Symbol> assignedSymbol = ExpressionUtils.getAssignedSymbol(newClassTree);
        MethodBodyVisitor visitor = new MethodBodyVisitor(assignedSymbol.orElse(null));
        enclosingMethod.accept(visitor);
        if (!visitor.foundCallsToSecuringMethods()) {
            this.reportIssue(newClassTree, "Secure this \"ActiveMQConnectionFactory\" by whitelisting the trusted packages using the \"setTrustedPackages\" method and make sure the \"setTrustAllPackages\" is not set to true.");
        }
    }

    private static class MethodBodyVisitor
    extends BaseTreeVisitor {
        private static final MethodMatchers SET_TRUSTED_PACKAGES = MethodMatchers.create().ofSubTypes("org.apache.activemq.ActiveMQConnectionFactory").names("setTrustedPackages").addParametersMatcher("*").build();
        private static final MethodMatchers SET_TRUST_ALL_PACKAGES = MethodMatchers.create().ofSubTypes("org.apache.activemq.ActiveMQConnectionFactory").names("setTrustAllPackages").addParametersMatcher("boolean").build();
        private boolean hasTrustedPackages = false;
        private boolean hasTrustAllPackages = false;
        private boolean callArgumentsOfSetTrustedPackages = false;
        private Symbol variable;

        MethodBodyVisitor(@Nullable Symbol variable) {
            this.variable = variable;
        }

        private boolean foundCallsToSecuringMethods() {
            return this.hasTrustedPackages && !this.hasTrustAllPackages;
        }

        @Override
        public void visitMethodInvocation(MethodInvocationTree methodInvocation) {
            if (ExpressionUtils.isInvocationOnVariable(methodInvocation, this.variable, true)) {
                Arguments arguments = methodInvocation.arguments();
                if (SET_TRUSTED_PACKAGES.matches(methodInvocation)) {
                    this.hasTrustedPackages |= !((ExpressionTree)arguments.get(0)).is(Tree.Kind.NULL_LITERAL);
                    this.callArgumentsOfSetTrustedPackages = true;
                } else if (SET_TRUST_ALL_PACKAGES.matches(methodInvocation)) {
                    this.hasTrustAllPackages |= Boolean.TRUE.equals(((ExpressionTree)arguments.get(0)).asConstant(Boolean.class).orElse(null));
                }
            }
            super.visitMethodInvocation(methodInvocation);
            this.callArgumentsOfSetTrustedPackages = false;
        }

        @Override
        public void visitLiteral(LiteralTree tree) {
            if (this.callArgumentsOfSetTrustedPackages && tree.is(Tree.Kind.STRING_LITERAL) && "*".equals(LiteralUtils.trimQuotes(tree.value()))) {
                this.hasTrustAllPackages = true;
            }
            super.visitLiteral(tree);
        }
    }
}

