/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.naming;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1221")
public class MethodNamedHashcodeOrEqualCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    @Override
    public void visitNode(Tree tree) {
        IdentifierTree methodIdentifier = ((MethodTree)tree).simpleName();
        switch (methodIdentifier.name()) {
            case "hashcode": {
                this.report(methodIdentifier, "hashCode()");
                break;
            }
            case "equal": {
                this.report(methodIdentifier, "equals(Object obj)");
                break;
            }
            case "tostring": {
                this.report(methodIdentifier, "toString()");
                break;
            }
        }
    }

    private void report(IdentifierTree methodIdentifier, String substitute) {
        this.reportIssue(methodIdentifier, "Either override Object." + substitute + ", or totally rename the method to prevent any confusion.");
    }
}

