/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.helpers;

import javax.annotation.CheckForNull;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

public class JavaPropertiesHelper {
    private JavaPropertiesHelper() {
    }

    @CheckForNull
    public static ExpressionTree retrievedPropertyDefaultValue(ExpressionTree expression) {
        if (expression.is(Tree.Kind.IDENTIFIER)) {
            return JavaPropertiesHelper.retrievedPropertyDefaultValue((IdentifierTree)expression);
        }
        if (expression.is(Tree.Kind.METHOD_INVOCATION)) {
            return JavaPropertiesHelper.retrievedPropertyDefaultValue((MethodInvocationTree)expression);
        }
        return null;
    }

    @CheckForNull
    private static ExpressionTree retrievedPropertyDefaultValue(IdentifierTree identifier) {
        ExpressionTree initializer;
        VariableTree declaration;
        Symbol symbol = identifier.symbol();
        if (symbol.usages().size() == 1 && (declaration = ((Symbol.VariableSymbol)symbol).declaration()) != null && (initializer = declaration.initializer()) != null && initializer.is(Tree.Kind.METHOD_INVOCATION)) {
            return JavaPropertiesHelper.retrievedPropertyDefaultValue((MethodInvocationTree)initializer);
        }
        return null;
    }

    @CheckForNull
    private static ExpressionTree retrievedPropertyDefaultValue(MethodInvocationTree mit) {
        if (JavaPropertiesHelper.isGetPropertyWithDefaultValue(mit)) {
            return (ExpressionTree)mit.arguments().get(1);
        }
        return null;
    }

    private static boolean isGetPropertyWithDefaultValue(MethodInvocationTree mit) {
        Symbol symbol = mit.symbol();
        if (symbol.isMethodSymbol() && symbol.owner().type().is("java.util.Properties")) {
            return "getProperty".equals(symbol.name()) && mit.arguments().size() == 2;
        }
        return false;
    }
}

