/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodReferenceTree;

@Rule(key="S1844")
public class WaitOnConditionCheck
extends AbstractMethodDetection {
    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofSubTypes("java.util.concurrent.locks.Condition").names("wait").addWithoutParametersMatcher().addParametersMatcher("long").addParametersMatcher("long", "int").build();
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        this.reportIssue(ExpressionUtils.methodName(mit), "The \"Condition.await(...)\" method should be used instead of \"Object.wait(...)\"");
    }

    @Override
    protected void onMethodReferenceFound(MethodReferenceTree methodReferenceTree) {
        this.reportIssue(methodReferenceTree.method(), "The \"Condition.await(...)\" method should be used instead of \"Object.wait(...)\"");
    }
}

