/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.EndOfAnalysisCheck;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.PackageDeclarationTree;

@Rule(key="S4032")
public class UselessPackageInfoCheck
implements JavaFileScanner,
EndOfAnalysisCheck {
    private final Map<String, JavaFileScannerContext> unneededPackageInfoFiles = new HashMap<String, JavaFileScannerContext>();
    private final Set<String> knownPackagesWithOtherFiles = new HashSet<String>();

    @Override
    public void scanFile(JavaFileScannerContext context) {
        File packageInfoFile;
        boolean hasOtherFiles;
        String packageName;
        PackageDeclarationTree packageDeclaration = context.getTree().packageDeclaration();
        String string = packageName = packageDeclaration == null ? null : ExpressionsHelper.concatenate(packageDeclaration.packageName());
        if (packageName == null || this.knownPackagesWithOtherFiles.contains(packageName)) {
            return;
        }
        File packageDirectory = context.getInputFile().file().getParentFile();
        boolean bl = hasOtherFiles = !UselessPackageInfoCheck.isOnlyFileFromPackage(packageDirectory, packageInfoFile = new File(packageDirectory, "package-info.java"));
        if (hasOtherFiles) {
            this.knownPackagesWithOtherFiles.add(packageName);
        } else if (packageInfoFile.isFile()) {
            this.unneededPackageInfoFiles.put(packageName, context);
        }
    }

    @Override
    public void endOfAnalysis() {
        this.unneededPackageInfoFiles.keySet().removeAll(this.knownPackagesWithOtherFiles);
        for (JavaFileScannerContext uselessPackageInfoFileContext : this.unneededPackageInfoFiles.values()) {
            uselessPackageInfoFileContext.addIssueOnFile(this, "Remove this package.");
        }
        this.unneededPackageInfoFiles.clear();
        this.knownPackagesWithOtherFiles.clear();
    }

    private static boolean isOnlyFileFromPackage(File packageDirectory, File file) {
        File[] filesInPackage = packageDirectory.listFiles(f -> !f.equals(file));
        return filesInPackage != null && filesInPackage.length == 0;
    }
}

