/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.JUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2438")
public class ThreadAsRunnableArgumentCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.NEW_CLASS, Tree.Kind.METHOD_INVOCATION);
    }

    @Override
    public void visitNode(Tree tree) {
        Arguments arguments;
        Symbol methodSymbol;
        if (tree.is(Tree.Kind.NEW_CLASS)) {
            NewClassTree nct = (NewClassTree)tree;
            methodSymbol = nct.constructorSymbol();
            arguments = nct.arguments();
        } else {
            MethodInvocationTree mit = (MethodInvocationTree)tree;
            methodSymbol = mit.symbol();
            arguments = mit.arguments();
        }
        if (!arguments.isEmpty() && methodSymbol.isMethodSymbol()) {
            this.checkArgumentsTypes(arguments, (Symbol.MethodSymbol)methodSymbol);
        }
    }

    private void checkArgumentsTypes(List<ExpressionTree> arguments, Symbol.MethodSymbol methodSymbol) {
        List<Type> parametersTypes = methodSymbol.parameterTypes();
        if (!parametersTypes.isEmpty()) {
            for (int index = 0; index < arguments.size(); ++index) {
                ExpressionTree argument = arguments.get(index);
                Type providedType = argument.symbolType();
                if (argument.is(Tree.Kind.NULL_LITERAL) || !ThreadAsRunnableArgumentCheck.isThreadAsRunnable(providedType, parametersTypes, index, JUtils.isVarArgsMethod(methodSymbol))) continue;
                this.reportIssue(argument, ThreadAsRunnableArgumentCheck.getMessage(argument, providedType, index));
            }
        }
    }

    private static boolean isThreadAsRunnable(Type providedType, List<Type> parametersTypes, int index, boolean varargs) {
        Type expectedType = ThreadAsRunnableArgumentCheck.getExpectedType(providedType, parametersTypes, index, varargs);
        return expectedType.is("java.lang.Runnable") && providedType.isSubtypeOf("java.lang.Thread") || expectedType.is("java.lang.Runnable[]") && providedType.isSubtypeOf("java.lang.Thread[]");
    }

    private static Type getExpectedType(Type providedType, List<Type> parametersTypes, int index, boolean varargs) {
        Type lastExpectedType;
        int lastParameterIndex = parametersTypes.size() - 1;
        Type lastParameterType = parametersTypes.get(lastParameterIndex);
        Type type = lastExpectedType = varargs ? ((Type.ArrayType)lastParameterType).elementType() : lastParameterType;
        if (index > lastParameterIndex || index == lastParameterIndex && varargs && !providedType.isArray()) {
            return lastExpectedType;
        }
        return parametersTypes.get(index);
    }

    private static String getMessage(ExpressionTree argument, Type providedType, int index) {
        String array = providedType.isArray() ? "[]" : "";
        return MessageFormat.format("\"{0}\" is a \"Thread{1}\".", ThreadAsRunnableArgumentCheck.getArgName(argument, index), array);
    }

    private static String getArgName(ExpressionTree tree, int index) {
        if (tree.is(Tree.Kind.IDENTIFIER)) {
            return ((IdentifierTree)tree).name();
        }
        return "Argument " + (index + 1);
    }
}

