/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.JUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3551")
public class SynchronizedOverrideCheck
extends IssuableSubscriptionVisitor {
    private static final String MESSAGE = "Make this method \"synchronized\" to match the parent class implementation.";

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    @Override
    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        Symbol.MethodSymbol methodSymbol = methodTree.symbol();
        List<Symbol.MethodSymbol> overriddenSymbols = methodSymbol.overriddenSymbols();
        if (overriddenSymbols.isEmpty()) {
            return;
        }
        Symbol.MethodSymbol overriddenSymbol = overriddenSymbols.get(0);
        if (JUtils.isSynchronizedMethod(overriddenSymbol) && !JUtils.isSynchronizedMethod(methodSymbol)) {
            List<JavaFileScannerContext.Location> secondaries = Collections.emptyList();
            MethodTree overridenMethodTree = overriddenSymbol.declaration();
            if (overridenMethodTree != null) {
                secondaries = Collections.singletonList(new JavaFileScannerContext.Location("", overridenMethodTree.simpleName()));
            }
            this.reportIssue(methodTree.simpleName(), MESSAGE, secondaries, null);
        }
    }
}

