/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.AbstractInSynchronizeChecker;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2444")
public class StaticFieldInitializationCheck
extends AbstractInSynchronizeChecker {
    private Deque<Boolean> classWithSynchronizedMethod = new LinkedList<Boolean>();
    private Deque<Boolean> withinStaticInitializer = new LinkedList<Boolean>();
    private Deque<Boolean> methodUsesLocks = new LinkedList<Boolean>();
    private MethodMatchers locks = MethodMatchers.create().ofTypes("java.util.concurrent.locks.Lock").names("lock", "tryLock").addWithoutParametersMatcher().build();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        ArrayList<Tree.Kind> nodesToVisit = new ArrayList<Tree.Kind>(super.nodesToVisit());
        nodesToVisit.add(Tree.Kind.CLASS);
        nodesToVisit.add(Tree.Kind.ASSIGNMENT);
        nodesToVisit.add(Tree.Kind.STATIC_INITIALIZER);
        return nodesToVisit;
    }

    @Override
    public void setContext(JavaFileScannerContext context) {
        this.classWithSynchronizedMethod.push(false);
        this.withinStaticInitializer.push(false);
        this.methodUsesLocks.push(false);
        super.setContext(context);
    }

    @Override
    public void leaveFile(JavaFileScannerContext context) {
        this.withinStaticInitializer.clear();
        this.methodUsesLocks.clear();
        this.classWithSynchronizedMethod.clear();
    }

    @Override
    public void visitNode(Tree tree) {
        switch (tree.kind()) {
            case CLASS: {
                this.classWithSynchronizedMethod.push(StaticFieldInitializationCheck.hasSynchronizedMethod((ClassTree)tree));
                break;
            }
            case STATIC_INITIALIZER: {
                this.withinStaticInitializer.push(true);
                break;
            }
            case METHOD: {
                this.methodUsesLocks.push(false);
                break;
            }
            case METHOD_INVOCATION: {
                if (!this.locks.matches((MethodInvocationTree)tree) || this.methodUsesLocks.size() == 1) break;
                this.methodUsesLocks.pop();
                this.methodUsesLocks.push(true);
                break;
            }
            case ASSIGNMENT: {
                IdentifierTree variable;
                AssignmentExpressionTree aet = (AssignmentExpressionTree)tree;
                if (!aet.variable().is(Tree.Kind.IDENTIFIER) || this.isInSyncBlock() || this.isInStaticInitializer() || this.isUsingLock() || !this.isInClassWithSynchronizedMethod() || !StaticFieldInitializationCheck.isStaticNotVolatileObject(variable = (IdentifierTree)aet.variable())) break;
                this.reportIssue(variable, "Synchronize this lazy initialization of '" + variable.name() + "'");
                break;
            }
        }
        super.visitNode(tree);
    }

    private boolean isInStaticInitializer() {
        return this.withinStaticInitializer.peek();
    }

    private static Boolean hasSynchronizedMethod(ClassTree tree) {
        return tree.members().stream().filter(member -> member.is(Tree.Kind.METHOD)).map(MethodTree.class::cast).map(MethodTree::modifiers).anyMatch(modifiers -> ModifiersUtils.hasModifier(modifiers, Modifier.SYNCHRONIZED));
    }

    private boolean isInClassWithSynchronizedMethod() {
        return this.classWithSynchronizedMethod.peek();
    }

    private boolean isUsingLock() {
        return this.methodUsesLocks.peek();
    }

    @Override
    public void leaveNode(Tree tree) {
        switch (tree.kind()) {
            case CLASS: {
                this.classWithSynchronizedMethod.pop();
                break;
            }
            case STATIC_INITIALIZER: {
                this.withinStaticInitializer.pop();
                break;
            }
            case METHOD: {
                this.methodUsesLocks.pop();
                break;
            }
        }
        super.leaveNode(tree);
    }

    private static boolean isStaticNotVolatileObject(IdentifierTree variable) {
        Symbol symbol = variable.symbol();
        if (symbol.isUnknown()) {
            return false;
        }
        return StaticFieldInitializationCheck.isStaticNotFinalNotVolatile(symbol) && !symbol.type().isPrimitive();
    }

    private static boolean isStaticNotFinalNotVolatile(Symbol symbol) {
        return symbol.isStatic() && !symbol.isVolatile() && !symbol.isFinal();
    }

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.none();
    }
}

