/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;

@Rule(key="S1989")
public class ServletMethodsExceptionsThrownCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers IS_SERVLET_DO_METHOD = MethodMatchers.create().ofSubTypes("javax.servlet.http.HttpServlet").name(name -> name.startsWith("do")).withAnyParameters().build();
    private final Deque<Boolean> shouldCheck = new ArrayDeque<Boolean>();
    private final Deque<List<Type>> tryCatches = new ArrayDeque<List<Type>>();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD, Tree.Kind.THROW_STATEMENT, Tree.Kind.METHOD_INVOCATION, Tree.Kind.TRY_STATEMENT, Tree.Kind.CATCH);
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(Tree.Kind.METHOD)) {
            this.shouldCheck.push(IS_SERVLET_DO_METHOD.matches((MethodTree)tree));
        } else if (this.shouldCheck()) {
            if (tree.is(Tree.Kind.TRY_STATEMENT)) {
                this.tryCatches.add(ServletMethodsExceptionsThrownCheck.getCaughtExceptions(((TryStatementTree)tree).catches()));
            } else if (tree.is(Tree.Kind.CATCH)) {
                this.tryCatches.pop();
                this.tryCatches.add(Collections.emptyList());
            } else if (tree.is(Tree.Kind.THROW_STATEMENT)) {
                this.addIssueIfNotCaught(((ThrowStatementTree)tree).expression().symbolType(), tree);
            } else if (tree.is(Tree.Kind.METHOD_INVOCATION)) {
                this.checkMethodInvocation((MethodInvocationTree)tree);
            }
        }
    }

    private boolean shouldCheck() {
        return !this.shouldCheck.isEmpty() && this.shouldCheck.peek() != false;
    }

    @Override
    public void leaveNode(Tree tree) {
        if (tree.is(Tree.Kind.METHOD)) {
            this.shouldCheck.pop();
        } else if (this.shouldCheck() && tree.is(Tree.Kind.TRY_STATEMENT)) {
            this.tryCatches.pop();
        }
    }

    private static List<Type> getCaughtExceptions(List<CatchTree> catches) {
        ArrayList<Type> result = new ArrayList<Type>();
        for (CatchTree element : catches) {
            result.add(element.parameter().type().symbolType());
        }
        return result;
    }

    private void checkMethodInvocation(MethodInvocationTree node) {
        List<Type> types;
        Symbol symbol = node.symbol();
        if (symbol.isMethodSymbol() && !(types = ((Symbol.MethodSymbol)symbol).thrownTypes()).isEmpty()) {
            this.addIssueIfNotCaught(types, ExpressionUtils.methodName(node), symbol.name());
        }
    }

    private void addIssueIfNotCaught(Type thrown, Tree node) {
        if (this.isNotCaught(thrown)) {
            String message = "Handle the \"" + thrown.name() + "\" thrown here in a \"try/catch\" block.";
            this.reportIssue(node, message);
        }
    }

    private void addIssueIfNotCaught(Iterable<Type> thrown, Tree node, String methodName) {
        ArrayList<Type> uncaughtTypes = new ArrayList<Type>();
        for (Type type : thrown) {
            if (!this.isNotCaught(type)) continue;
            uncaughtTypes.add(type);
        }
        if (!uncaughtTypes.isEmpty()) {
            this.reportIssue(node, ServletMethodsExceptionsThrownCheck.buildMessage(methodName, uncaughtTypes));
        }
    }

    private static String buildMessage(String methodName, List<Type> uncaughtTypes) {
        String uncaught = uncaughtTypes.stream().map(Type::name).collect(Collectors.joining(", ")) + ".";
        return String.format("Handle the following exception%s that could be thrown by \"%s\": %s", uncaughtTypes.size() == 1 ? "" : "s", methodName, uncaught);
    }

    private boolean isNotCaught(Type type) {
        for (List<Type> tryCatch : this.tryCatches) {
            for (Type tryCatchType : tryCatch) {
                if (!type.isSubtypeOf(tryCatchType)) continue;
                return false;
            }
        }
        return true;
    }
}

