/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ReassignmentFinder;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2695")
public class PreparedStatementAndResultSetCheck
extends AbstractMethodDetection {
    private static final String INT = "int";
    private static final String JAVA_SQL_RESULTSET = "java.sql.ResultSet";
    private static final MethodMatchers PREPARE_STATEMENT = MethodMatchers.create().ofTypes("java.sql.Connection").name(name -> name.startsWith("prepareStatement")).withAnyParameters().build();

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or(MethodMatchers.create().ofTypes("java.sql.PreparedStatement").name(name -> name.startsWith("set")).addParametersMatcher(INT, "*").build(), MethodMatchers.create().ofTypes(JAVA_SQL_RESULTSET).name(name -> name.startsWith("get")).addParametersMatcher(INT).addParametersMatcher(INT, "*").build());
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        ExpressionTree firstArgument = (ExpressionTree)mit.arguments().get(0);
        Integer methodFirstArgumentAsInteger = LiteralUtils.intLiteralValue(firstArgument);
        if (methodFirstArgumentAsInteger == null) {
            return;
        }
        boolean isMethodFromJavaSqlResultSet = mit.symbol().owner().type().is(JAVA_SQL_RESULTSET);
        int methodFirstArgumentValue = methodFirstArgumentAsInteger;
        if (isMethodFromJavaSqlResultSet && methodFirstArgumentValue == 0) {
            this.reportIssue(firstArgument, "ResultSet indices start at 1.");
        } else if (!isMethodFromJavaSqlResultSet) {
            if (methodFirstArgumentValue == 0) {
                this.reportIssue(firstArgument, "PreparedStatement indices start at 1.");
            } else {
                ExpressionTree preparedStatementReference = PreparedStatementAndResultSetCheck.getPreparedStatementReference(mit);
                Integer numberParameters = PreparedStatementAndResultSetCheck.getPreparedStatementNumberOfParameters(preparedStatementReference);
                if (numberParameters != null && methodFirstArgumentValue > numberParameters) {
                    this.reportIssue(firstArgument, "This \"PreparedStatement\" " + (numberParameters == 0 ? "has no" : "only has " + numberParameters) + " parameters.");
                }
            }
        }
    }

    @CheckForNull
    private static ExpressionTree getPreparedStatementReference(MethodInvocationTree mit) {
        ExpressionTree methodSelect = mit.methodSelect();
        if (methodSelect.is(Tree.Kind.MEMBER_SELECT)) {
            ExpressionTree expression = ((MemberSelectExpressionTree)methodSelect).expression();
            if (expression.is(Tree.Kind.IDENTIFIER)) {
                Symbol referenceSymbol = ((IdentifierTree)expression).symbol();
                return ReassignmentFinder.getClosestReassignmentOrDeclarationExpression(mit, referenceSymbol);
            }
        }
        return null;
    }

    @CheckForNull
    private static Integer getPreparedStatementNumberOfParameters(@Nullable ExpressionTree tree) {
        Arguments arguments;
        if (tree != null && tree.is(Tree.Kind.METHOD_INVOCATION) && !(arguments = ((MethodInvocationTree)tree).arguments()).isEmpty() && PREPARE_STATEMENT.matches((MethodInvocationTree)tree)) {
            return PreparedStatementAndResultSetCheck.getNumberQuery((ExpressionTree)arguments.get(0));
        }
        return null;
    }

    @CheckForNull
    private static Integer getNumberQuery(ExpressionTree expression) {
        ExpressionTree expr = ExpressionUtils.skipParentheses(expression);
        if (expr.is(Tree.Kind.IDENTIFIER)) {
            return PreparedStatementAndResultSetCheck.handleVariableUsedAsQuery((IdentifierTree)expr);
        }
        if (expr.is(Tree.Kind.PLUS)) {
            return PreparedStatementAndResultSetCheck.handleStringConcatenation((BinaryExpressionTree)expr);
        }
        return PreparedStatementAndResultSetCheck.countQuery(expr);
    }

    private static Integer handleVariableUsedAsQuery(IdentifierTree identifier) {
        ExpressionTree lastAssignmentExpr = ReassignmentFinder.getClosestReassignmentOrDeclarationExpression(identifier, identifier.symbol());
        if (lastAssignmentExpr != null) {
            Tree lastAssignment = lastAssignmentExpr.parent();
            if (lastAssignment.is(Tree.Kind.PLUS_ASSIGNMENT)) {
                return PreparedStatementAndResultSetCheck.zeroIfNull(PreparedStatementAndResultSetCheck.getNumberQuery(lastAssignmentExpr)) + PreparedStatementAndResultSetCheck.zeroIfNull(PreparedStatementAndResultSetCheck.getNumberQuery(((AssignmentExpressionTree)lastAssignment).variable()));
            }
            if (!PreparedStatementAndResultSetCheck.isPartOfExpression(identifier, lastAssignmentExpr)) {
                return PreparedStatementAndResultSetCheck.getNumberQuery(lastAssignmentExpr);
            }
        }
        return null;
    }

    private static boolean isPartOfExpression(IdentifierTree identifier, ExpressionTree lastAssignment) {
        Tree parent = identifier;
        while ((parent = parent.parent()) != null && !parent.equals(lastAssignment)) {
        }
        return parent != null;
    }

    private static Integer handleStringConcatenation(BinaryExpressionTree expr) {
        Integer left = PreparedStatementAndResultSetCheck.getNumberQuery(expr.leftOperand());
        Integer right = PreparedStatementAndResultSetCheck.getNumberQuery(expr.rightOperand());
        return left == null && right == null ? null : Integer.valueOf(PreparedStatementAndResultSetCheck.zeroIfNull(left) + PreparedStatementAndResultSetCheck.zeroIfNull(right));
    }

    private static int zeroIfNull(@Nullable Integer intValue) {
        return intValue == null ? 0 : intValue;
    }

    @CheckForNull
    private static Integer countQuery(ExpressionTree expression) {
        return expression.is(Tree.Kind.STRING_LITERAL) ? Integer.valueOf(StringUtils.countMatches(((LiteralTree)expression).value(), "?")) : null;
    }
}

