/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.SwitchExpressionTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.SwitchTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1821")
public class NestedSwitchCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.SWITCH_STATEMENT, Tree.Kind.SWITCH_EXPRESSION);
    }

    @Override
    public void visitNode(Tree tree) {
        NestedSwitchVisitor visitor = new NestedSwitchVisitor();
        ((SwitchTree)tree).cases().forEach(c -> c.accept(visitor));
    }

    private class NestedSwitchVisitor
    extends BaseTreeVisitor {
        private NestedSwitchVisitor() {
        }

        @Override
        public void visitClass(ClassTree tree) {
        }

        @Override
        public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        }

        @Override
        public void visitSwitchStatement(SwitchStatementTree tree) {
            this.reportNestedSwitch(tree);
        }

        @Override
        public void visitSwitchExpression(SwitchExpressionTree tree) {
            this.reportNestedSwitch(tree);
        }

        private void reportNestedSwitch(SwitchTree switchTree) {
            NestedSwitchCheck.this.reportIssue(switchTree.switchKeyword(), "Refactor the code to eliminate this nested \"switch\".");
        }
    }
}

