/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1185")
public class MethodOnlyCallsSuperCheck
extends IssuableSubscriptionVisitor {
    private static final List<String> TRANSACTIONAL_ANNOTATIONS = Arrays.asList("javax.transaction.Transactional", "org.springframework.transaction.annotation.Transactional");
    private static final MethodMatchers ALLOWED_METHODS = MethodMatchers.or(MethodMatchers.create().ofAnyType().names("toString", "hashCode").addWithoutParametersMatcher().build(), MethodMatchers.create().ofAnyType().names("equals").addParametersMatcher("java.lang.Object").build());

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    @Override
    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (ALLOWED_METHODS.matches(methodTree)) {
            return;
        }
        if (MethodOnlyCallsSuperCheck.isSingleStatementMethod(methodTree) && MethodOnlyCallsSuperCheck.isUselessSuperCall(methodTree) && !MethodOnlyCallsSuperCheck.hasAnnotationDifferentFromOverride(methodTree.modifiers().annotations()) && !MethodOnlyCallsSuperCheck.isFinal(methodTree) && !MethodOnlyCallsSuperCheck.isClassAnnotatedWithTransactional(methodTree)) {
            this.reportIssue(methodTree.simpleName(), "Remove this method to simply inherit it.");
        }
    }

    private static boolean isFinal(MethodTree methodTree) {
        return ModifiersUtils.hasModifier(methodTree.modifiers(), Modifier.FINAL);
    }

    private static boolean isSingleStatementMethod(MethodTree methodTree) {
        BlockTree block = methodTree.block();
        return block != null && block.body().size() == 1;
    }

    private static boolean isUselessSuperCall(MethodTree methodTree) {
        ExpressionTree callToSuper = null;
        StatementTree statementTree = methodTree.block().body().get(0);
        if (MethodOnlyCallsSuperCheck.returnsVoid(methodTree) && statementTree.is(Tree.Kind.EXPRESSION_STATEMENT)) {
            callToSuper = ((ExpressionStatementTree)statementTree).expression();
        } else if (statementTree.is(Tree.Kind.RETURN_STATEMENT)) {
            callToSuper = ((ReturnStatementTree)statementTree).expression();
        }
        if (callToSuper == null || !MethodOnlyCallsSuperCheck.isCallToSuper(methodTree, callToSuper)) {
            return false;
        }
        Symbol parentMethod = ((MethodInvocationTree)callToSuper).symbol();
        if (parentMethod.isUnknown()) {
            return false;
        }
        return MethodOnlyCallsSuperCheck.sameVisibility(methodTree.symbol(), parentMethod);
    }

    private static boolean sameVisibility(Symbol.MethodSymbol method, Symbol parentMethod) {
        return MethodOnlyCallsSuperCheck.bothPackage(method, parentMethod) || MethodOnlyCallsSuperCheck.bothProtected(method, parentMethod) || MethodOnlyCallsSuperCheck.bothPublic(method, parentMethod);
    }

    private static boolean bothPackage(Symbol.MethodSymbol method, Symbol parentMethod) {
        return method.isPackageVisibility() && parentMethod.isPackageVisibility();
    }

    private static boolean bothProtected(Symbol.MethodSymbol method, Symbol parentMethod) {
        return method.isProtected() && parentMethod.isProtected();
    }

    private static boolean bothPublic(Symbol.MethodSymbol method, Symbol parentMethod) {
        return method.isPublic() && parentMethod.isPublic();
    }

    private static boolean isCallToSuper(MethodTree methodTree, Tree callToSuper) {
        MemberSelectExpressionTree mset;
        MethodInvocationTree methodInvocationTree;
        return callToSuper.is(Tree.Kind.METHOD_INVOCATION) && (methodInvocationTree = (MethodInvocationTree)callToSuper).methodSelect().is(Tree.Kind.MEMBER_SELECT) && MethodOnlyCallsSuperCheck.callSuperMethodWithSameName(mset = (MemberSelectExpressionTree)methodInvocationTree.methodSelect(), methodTree) && MethodOnlyCallsSuperCheck.callsWithSameParameters(methodInvocationTree.arguments(), methodTree.parameters());
    }

    private static boolean callSuperMethodWithSameName(MemberSelectExpressionTree mset, MethodTree methodTree) {
        return mset.expression().is(Tree.Kind.IDENTIFIER) && "super".equals(((IdentifierTree)mset.expression()).name()) && mset.identifier().name().equals(methodTree.simpleName().name());
    }

    private static boolean callsWithSameParameters(List<ExpressionTree> arguments, List<VariableTree> parameters) {
        if (arguments.size() != parameters.size()) {
            return false;
        }
        for (int i = 0; i < arguments.size(); ++i) {
            ExpressionTree arg = arguments.get(i);
            VariableTree param = parameters.get(i);
            if (arg.is(Tree.Kind.IDENTIFIER) && ((IdentifierTree)arg).name().equals(param.simpleName().name())) continue;
            return false;
        }
        return true;
    }

    private static boolean returnsVoid(MethodTree methodTree) {
        TypeTree returnType = methodTree.returnType();
        return returnType != null && returnType.is(Tree.Kind.PRIMITIVE_TYPE) && "void".equals(((PrimitiveTypeTree)returnType).keyword().text());
    }

    private static boolean hasAnnotationDifferentFromOverride(List<AnnotationTree> annotations) {
        for (AnnotationTree annotation : annotations) {
            if (annotation.annotationType().is(Tree.Kind.IDENTIFIER) && "Override".equals(((IdentifierTree)annotation.annotationType()).name())) continue;
            return true;
        }
        return false;
    }

    private static boolean isClassAnnotatedWithTransactional(MethodTree methodTree) {
        SymbolMetadata metadata = methodTree.symbol().enclosingClass().metadata();
        return TRANSACTIONAL_ANNOTATIONS.stream().anyMatch(metadata::isAnnotatedWith);
    }
}

