/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;

@Rule(key="S2127")
public class LongBitsToDoubleOnIntCheck
extends AbstractMethodDetection {
    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes("java.lang.Double").names("longBitsToDouble").addParametersMatcher("long").build();
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        Type symbolType = ((ExpressionTree)mit.arguments().get(0)).symbolType();
        if (!symbolType.is("long") && !symbolType.is("java.lang.Long")) {
            this.reportIssue(ExpressionUtils.methodName(mit), "Remove this \"Double.longBitsToDouble\" call.");
        }
    }
}

